package com.biz.crm.dms.business.policy.sdk.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import lombok.Getter;
import lombok.Setter;

/**
 * 默认的附件（含图片）管理模块实现中，关键配置信息
 * @author yinwenjie
 */
@Component
@ConfigurationProperties(prefix = "dms.policy")
@Getter
@Setter
public class SimplePolicyProperties {
  /**
   * 按照模板类型进行的优惠政策执行顺序，注意，就算整单优惠排列在本品优惠的前面，整单优惠也会滞后执行</br>
   * 默认的执行顺序为：本品买赠、本品满减单价、本品单价特价、本品满减总价、本品满折总价、本品总价特价*、整单买赠、整单满减总价、整单满折总价
   */
  private String[] typesorts = new String[] {"standard_given_supportproduct" , "standard_fullminus_unitprice_supportproduct","standard_special_unitprice_supportproduct","standard_fullminus_subtotal_supportproduct",
                                             "standard_discount_supportproduct" , "standard_given_unsupportproduct" , "standard_fullminus_subtotal_unsupportproduct","standard_discount_unsupportproduct"};
  
} 
