package com.biz.crm.dms.business.policy.sdk.context;

/**
 * 阶梯循环执行上下文（CycleExecuteContext），请注意优惠政策执行上下文接口AbstractPolicyExecuteContext和阶梯循环执行上下文的区别：</br>
 * 1、作用域不一样，优惠政策执行上下文AbstractPolicyExecuteContext作用于整个优惠政策执行过程；
 * 阶梯循环执行上下文，只作用于带入一批本品的某一次完整的优惠政策阶梯执行过程。</br>
 * 2、信息范围不一样，例如阶梯循环执行上下文也存在“小计价格”、“小计数量”的属性，但是这些“小计价格”、“小计数量”并不是针对整个业务单据，而只是针对参与本次优惠政策计算的这批物资。
 * @author yinwenjie
 */
public interface AbstractCycleExecuteContext {
  /**
   * 作为阶梯循环执行上下文，就是要有优惠政策中具体执行器的信息
   * @return 
   */
  public String getExecuteCode();
  
  /**
   * 作为阶梯循环执行上下文，就是要确认当前正在执行的客户信息
   * @return
   */
  public String getCustomerCode();
}

