package com.biz.crm.dms.business.policy.sdk.context;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Set;

import com.google.common.collect.Sets;

import lombok.Getter;

/**
 * 这里记录了在某一次优惠政策执行所有优惠阶梯的过程中，每一个已执行的阶梯的执行结果</br>
 * 注意，某一层级的阶梯是可能执行多次的
 * @author yinwenjie
 */
@Getter
public class CycleStepResult implements Serializable {
  private static final long serialVersionUID = 5052532266642210699L;

  /**
   * 阶梯序号，从0开始，阶梯序号越小，说明越是先被执行。
   */
  private Integer ladderIndex;
  /**
   * 第几次执行，从1开始，1表示第一次执行</br>
   * 且executeTimes属性，本身不会重复
   * ladderIndex和executeTimes往往被联合使用。例如:</br>
   * ladderIndex = 0 ，executeTimes = 2，表示，第0号阶梯第2次执行
   */
  private Integer executeTimes;
  
  // ======= 以下表示阶梯执行前的情况：
  
  /**
   * 本次阶梯计算前的小计价格（也就是上次阶梯计算后的小计价格，或者初始小计价格）
   */
  private final BigDecimal preSubtotalAmount;
  /**
   * 本次阶梯计算前，还有多小小计价格没有享受优惠
   */
  private final BigDecimal preSurplusSubtotalAmount;
  /**
   * 本次阶梯计算前，还有多小小计数量没有享受优惠
   */
  private final Integer preSurplusSubtotalNumber;
  
  // ======= 以下表示阶梯执行后的情况：
  
  /**
   * 本次阶梯计算后的小计价格
   */
  private BigDecimal lastSubtotalAmount;
  /**
   * 本次阶梯计算后，得到的赠品情况(注意，是累加的)
   */
  private Set<GiftResultInfo> lastGifts;
  /**
   * 本次阶梯计算后，还有多少小计价格没有享受优惠
   */
  private BigDecimal lastSurplusSubtotalAmount;
  /**
   * 本次阶梯计算后，还有多少小计数量没有享受优惠
   */
  private Integer lastSurplusSubtotalNumber;
  
  /**
   * 构造单个阶梯的执行结果时，执行前的信息必须传入
   * @param preSubtotalAmount
   * @param preSurplusSubtotalAmount
   * @param preSurplusSubtotalNumber
   */
  public CycleStepResult(int ladderIndex , int executeTimes , BigDecimal preSubtotalAmount, BigDecimal preSurplusSubtotalAmount, Integer preSurplusSubtotalNumber) {
    this.ladderIndex = ladderIndex;
    this.executeTimes = executeTimes;
    this.preSubtotalAmount = preSubtotalAmount;
    this.preSurplusSubtotalAmount = preSurplusSubtotalAmount;
    this.preSurplusSubtotalNumber = preSurplusSubtotalNumber;
    
    // 其它值也必然进行初始化
    this.lastGifts = Sets.newLinkedHashSet();
    this.lastSubtotalAmount = preSubtotalAmount;
    this.lastSurplusSubtotalAmount = preSurplusSubtotalAmount;
    this.lastSurplusSubtotalNumber = preSurplusSubtotalNumber;
  }
  
  public void setLastSubtotalAmount(BigDecimal lastSubtotalAmount) {
    this.lastSubtotalAmount = lastSubtotalAmount;
  }

  public void setLastSurplusSubtotalAmount(BigDecimal lastSurplusSubtotalAmount) {
    this.lastSurplusSubtotalAmount = lastSurplusSubtotalAmount;
  }

  public void setLastSurplusSubtotalNumber(Integer lastSurplusSubtotalNumber) {
    this.lastSurplusSubtotalNumber = lastSurplusSubtotalNumber;
  }

  public void setLastGifts(Set<GiftResultInfo> lastGifts) {
    this.lastGifts = lastGifts;
  }
}
