package com.biz.crm.dms.business.policy.sdk.context;

import java.io.Serializable;
import java.math.BigDecimal;

import io.swagger.annotations.ApiModel;
import lombok.Getter;
import lombok.Setter;

/**
 * 优惠政策计算/预计算后得到的赠品计算结果
 * @author yinwenjie
 */
@Setter
@Getter
@ApiModel(value = "GiftResultInfo", description = "优惠政策计算/预计算后得到的赠品计算结果")
public class GiftResultInfo implements Serializable {
  private static final long serialVersionUID = -7804087118826163465L;
  /** 赠品规格编号 */
  private String productCode;
  /** 赠品（规格）名称 */
  private String productName;
  /** 赠品数量，只能为整数 */
  private Integer quantity;
  /** 赠品价值小计 */
  private BigDecimal subtotalAmount;
}
