package com.biz.crm.dms.business.policy.sdk.context;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import lombok.Getter;
import lombok.Setter;

/**
 * 针对每一个优惠政策的步进信息
 * @author yinwenjie
 */
@Setter
@Getter
public class PolicyStepResult implements Serializable {
  private static final long serialVersionUID = 1809517961050460337L;
  /**
   * 优惠步进类型(即这次步进是因为什么原因产生的)
   */
  private StepType stepType;
  /**
   * 这次优惠步进对应的优惠政策（可能没有，例如是初始化的时候）
   */
  private String salePolicyCode;
  /**
   * 本次优惠步进的执行，是使用的优惠政策中的哪个执行器完成的
   */
  private String executorCode;
  
  // ====== 以下是单据的初始化维度的信息
  /**
   * 单据在带入任意优惠政策前，所有的本品初始化数量值
   */
  private Integer initNumbers;
  /**
   * 单据在带入任意优惠政策前，所有的本品初始总计价格值
   */
  private BigDecimal initSubtotal;
  
  // ====== 以下是单据优惠政策执行前的信息
  
  /**
   * 单据在执行本次优惠政策前，本单据的总计价格
   */
  private BigDecimal preSubtotal;
  /**
   * 单据在执行本次优惠政策前，已经存在的赠品信息
   */
  private List<GiftResultInfo> preGifts;
  /**
   * 单据在执行本次优惠政策前，还有多少总计数量没有享受优惠 
   */
  private Integer preSurplusTotalNumber;
  /**
   * 单据在执行本次优惠政策前，还有多少总计价格没有享受优惠
   */
  private BigDecimal preSurplusTotalAmount;
  /**
   * 单据在执行本次优惠政策前，已享受的赠品数量优惠</p>
   * 一定要看清楚，这里是已享受的，而不是Surplus那种还没有享受的
   */
  private Integer preGiftEnjoyedTotalNumber;
  /**
   * 单据在执行本次优惠政策前，已享受的赠品金额优惠</p>
   * 一定要看清楚，这里是已享受的，而不是Surplus那种还没有享受的
   */
  private BigDecimal preGiftEnjoyedTotalAmount;
  
  // ====== 以下是单据优惠政策执行后的信息
  
  /**
   * 单据在执行本次优惠政策后，本单据的总计价格
   */
  private BigDecimal lastSubtotal;
  /**
   * 单据在执行本次优惠政策后，最新的赠品信息（包括新增和已有的两部分）
   */
  private List<GiftResultInfo> lastGifts;
  /**
   * 单据在执行本次优惠政策后，还有多少单据总计数量没有享受优惠
   */
  private Integer lastSurplusTotalNumber;
  /**
   * 单据在执行本次优惠政策后，还有多少单据总计价格没有享受优惠
   */
  private BigDecimal lastSurplusTotalAmount;
  /**
   * 单据在执行本次优惠政策后，已享受的赠品数量优惠</p>
   * 一定要看清楚，这里是已享受的，而不是Surplus那种还没有享受的
   */
  private Integer lastGiftEnjoyedTotalNumber;
  /**
   * 单据在执行本次优惠政策后，已享受的赠品金额优惠</p>
   * 一定要看清楚，这里是已享受的，而不是Surplus那种还没有享受的
   */
  private BigDecimal lastGiftEnjoyedTotalAmount;
}
