package com.biz.crm.dms.business.policy.sdk.context;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import lombok.Getter;
import lombok.Setter;

/**
 * 针对每一条商品的优惠步进，这是指单据上的某一条商品，依次在优惠计算开始前、A优惠执行后、B优惠执行后的每一次计算状态
 * @author yinwenjie
 */
@Setter
@Getter
public class ProductPolicyStepResult implements Serializable {
  private static final long serialVersionUID = 1809517961050460337L;
  /**
   * 优惠步进类型(即这次步进是因为什么原因产生的)
   */
  private StepType stepType;
  /**
   * 对应的商品业务编码信息
   */
  private String productCode;
  /**
   * 这次优惠步进对应的优惠政策（可能没有，例如是初始化的时候）
   */
  private String salePolicyCode;
  /**
   * 本次优惠步进的执行，是使用的优惠政策中的哪个执行器完成的
   */
  private String executeCode;
  
  // ====== 以下是商品的初始化维度的信息
  /**
   * 商品初始化的单价信息
   */
  private BigDecimal initPrices;
  /**
   * 商品初始化的数量信息
   */
  private Integer initNumbers;
  /**
   * 商品初始化的小计价格信息
   */
  private BigDecimal initSubtotal;
  
  // ====== 以下是商品优惠政策执行前的信息
  
  /**
   * 商品在执行本次优惠政策前，商品的单价
   */
  private BigDecimal prePrices;
  /**
   * 商品在执行本次优惠政策前，商品的小计价格
   */
  private BigDecimal preSubtotal;
  /**
   * 商品在执行本次优惠政策前，已经存在的赠品信息
   */
  private List<GiftResultInfo> preGifts;
  /**
   *商品在执行本次优惠政策前，还有多少小计价格没有享受优惠 
   */
  private Integer preSurplusTotalNumber;
  /**
   * 商品在执行本次优惠政策前，还有多少小计价格没有享受优惠
   */
  private BigDecimal preSurplusTotalAmount;
  /**
   * 商品在执行本次优惠政策前，已享受的赠品数量优惠</p>
   * 一定要看清楚，这里是已享受的，而不是Surplus那种还没有享受的
   */
  private Integer preGiftEnjoyedTotalNumber;
  /**
   * 商品在执行本次优惠政策前，已享受的赠品金额优惠</p>
   * 一定要看清楚，这里是已享受的，而不是Surplus那种还没有享受的
   */
  private BigDecimal preGiftEnjoyedTotalAmount;
  
  // ====== 以下是商品优惠政策执行后的信息
  
  /**
   * 商品在执行本次优惠政策后，商品的单价
   */
  private BigDecimal lastPrices;
  /**
   * 商品在执行本次优惠政策后，商品的小计价格
   */
  private BigDecimal lastSubtotal;
  /**
   * 商品在执行本次优惠政策后，最新的赠品信息（包括新增和已有的两部分）
   */
  private List<GiftResultInfo> lastGifts;
  /**
   * 商品在执行本次优惠政策后，还有多少商品数量没有享受优惠
   */
  private Integer lastSurplusTotalNumber;
  /**
   * 商品在执行本次优惠政策后，还有多少小计价格没有享受优惠
   */
  private BigDecimal lastSurplusTotalAmount;
  /**
   * 商品在执行本次优惠政策后，已享受的赠品数量优惠</p>
   * 一定要看清楚，这里是已享受的，而不是Surplus那种还没有享受的
   */
  private Integer lastGiftEnjoyedTotalNumber;
  /**
   * 商品在执行本次优惠政策后，已享受的赠品金额优惠</p>
   * 一定要看清楚，这里是已享受的，而不是Surplus那种还没有享受的
   */
  private BigDecimal lastGiftEnjoyedTotalAmount;
}
