package com.biz.crm.dms.business.policy.sdk.context;

import java.io.Serializable;
import java.math.BigDecimal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 关于优惠政策执行/预执行时，本品信息入参的最基本模型定义
 * @author yinwenjie
 */
@Setter
@Getter
@ApiModel(value = "SalePolicyConProduct", description = "关于优惠政策执行/预执行时，本品信息入参的最基本模型定义")
public class SalePolicyConProduct implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = -2604725606454011665L;
  /** 本品商品规格编号 */
  @ApiModelProperty("本品商品规格编号")
  private String productCode;
  /** 本品商品名称（不一定有，但有就会在正式执行是保存） */
  @ApiModelProperty("本品商品名称（不一定有，但有就会在正式执行是保存）")
  private String productName;
  /** 票据行项目号（正式执行时必须有，由外部单据传入，可以是行数号，也可以是单据明细项的id，只要能说明是单据上的哪一行具体商品就行）*/
  @ApiModelProperty("正式执行时必须有，票据行项目号（由外部单据传入，可以是行数号，也可以是单据明细项的id，只要能说明是单据上的哪一行具体商品就行）")
  private String billItemCode;
  /** 订货数量：最多四位小数 */
  @ApiModelProperty("订货数量：最多四位小数（预判定时，可不传入）")
  private BigDecimal quantity = BigDecimal.ONE;
  /** 订单商品单价 */
  @ApiModelProperty("订单商品单价（预判定时，可不传入）")
  private BigDecimal unitPrice = BigDecimal.ZERO;
  /** 小计金额 */
  @ApiModelProperty("小计金额（预判定时，可不传入）")
  private BigDecimal subtotalAmount = BigDecimal.ZERO;
  /**
   * 进行优惠政策执行/预执行时，可以为某个本品指定他要参加的优惠政策（的业务编码）</br>
   * 注意，指定的业务编码只能在该本品本身能够参与的优惠政策中进行选定。
   */
  @ApiModelProperty(value = "进行优惠政策执行/预执行时，可以为某个本品指定他要参加的优惠政策（的业务编码）" , notes = "注意，指定的业务编码只能在该本品本身能够参与的优惠政策中进行选定")
  private String[] selectedPolicyCodes;
}
