package com.biz.crm.dms.business.policy.sdk.context;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Set;

import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

import lombok.Getter;

/**
 * 这是记录每一次阶梯执行前后，每一个物资的变化单价、小计价格变化情况（注意，本品数量是不会变的）</br>
 * 这种阶梯执行上下文可以用于 商品-满减单价、商品-单价特价 的优惠场景
 * TODO 操作便利性后续再做优化了
 * @author yinwenjie
 */
@Getter
public class UnitpriceCycleStepResult implements Serializable {
  private static final long serialVersionUID = -401321424964833507L;
  /**
   * 阶梯序号，从0开始，阶梯序号越小，说明越是先被执行。
   */
  private Integer ladderIndex;
  /**
   * 第几次执行，从1开始，1表示第一次执行</br>
   * 且executeTimes属性，本身不会重复
   * ladderIndex和executeTimes往往被联合使用。例如:</br>
   * ladderIndex = 0 ，executeTimes = 2，表示，第0号阶梯第2次执行
   */
  private Integer executeTimes;
  
  // ======= 以下表示阶梯执行前的情况：
  
  /**
   * 本次阶梯计算前的小计价格（也就是上次阶梯计算后的小计价格，或者初始小计价格）
   */
  private final BigDecimal preSubtotalAmount;
  /**
   * 本次阶梯计算前，还有多小小计价格没有享受优惠
   */
  private final BigDecimal preSurplusSubtotalAmount;
  /**
   * 本次阶梯计算前，还有多小小计数量没有享受优惠
   */
  private final Integer preSurplusSubtotalNumber;
  /**
   * 本次阶梯执行前，各本品的单价情况
   */
  private Set<UnitpriceProduct> preProducts;
  
  // ======= 以下表示阶梯执行后的情况：
  
  /**
   * 本次阶梯计算后的小计价格
   */
  private BigDecimal lastSubtotalAmount;
  /**
   * 本次阶梯计算后，还有多少小计价格没有享受优惠
   */
  private BigDecimal lastSurplusSubtotalAmount;
  /**
   * 本次阶梯计算后，还有多少小计数量没有享受优惠
   */
  private Integer lastSurplusSubtotalNumber;
  /**
   * 本次阶梯执行后，各本品的单价情况
   */
  private Set<UnitpriceProduct> lastProducts;

  public UnitpriceCycleStepResult(int ladderIndex , int executeTimes , BigDecimal preSubtotalAmount, BigDecimal preSurplusSubtotalAmount, Integer preSurplusSubtotalNumber , Set<UnitpriceProduct> preProducts) {
    this.ladderIndex = ladderIndex;
    this.executeTimes = executeTimes;
    this.preSubtotalAmount = preSubtotalAmount;
    this.preSurplusSubtotalAmount = preSurplusSubtotalAmount;
    this.preSurplusSubtotalNumber = preSurplusSubtotalNumber;
    Validate.isTrue(!CollectionUtils.isEmpty(preProducts) , "进行商品-满减单价计算时，任何阶梯都不可能没有商品本品信息，请检查");
    this.preProducts = preProducts;
  }
  
  public void setLastSubtotalAmount(BigDecimal lastSubtotalAmount) {
    this.lastSubtotalAmount = lastSubtotalAmount;
  }

  public void setLastSurplusSubtotalAmount(BigDecimal lastSurplusSubtotalAmount) {
    this.lastSurplusSubtotalAmount = lastSurplusSubtotalAmount;
  }

  public void setLastSurplusSubtotalNumber(Integer lastSurplusSubtotalNumber) {
    this.lastSurplusSubtotalNumber = lastSurplusSubtotalNumber;
  }
  
  public void setLastProducts(Set<UnitpriceProduct> lastProducts) {
    this.lastProducts = lastProducts;
  }
}