package com.biz.crm.dms.business.policy.sdk.context;

import java.io.Serializable;
import java.math.BigDecimal;

import lombok.Getter;

/**
 * 针对每一条商品的阶梯优惠步进
 * @author yinwenjie
 */
@Getter
public class UnitpriceProduct implements Serializable {
  private static final long serialVersionUID = 1809517961050460337L;
  
  public UnitpriceProduct(String productCode, Integer numbers, BigDecimal prices) {
    this.productCode = productCode;
    this.numbers = numbers;
    this.prices = prices;
  }
  /**
   * 对应的商品业务编码信息
   */
  private String productCode;
  /**
   * 商品数量信息（注意，阶梯中无论怎么优惠，商品数量是不会改变的）
   */
  private Integer numbers;
  /**
   * 商品的单价
   */
  private BigDecimal prices;
}
