package com.biz.crm.dms.business.policy.sdk.enums;

import java.util.Optional;
import java.util.stream.Stream;

import lombok.Getter;

@Getter
public enum BudgetType {
  /** 各种预算要素（执行方式、限量控制方法等）对预算的支持方式 */
  SUPPORT("support", "支持"),
  UNSUPPORT("unsupport", "不支持"),
  ;

  private String code;
  private String desc;

  BudgetType(String code, String desc) {
    this.code = code;
    this.desc = desc;
  }

  public static Boolean exists(String value) {
    Optional<BudgetType> first =
        Stream.of(BudgetType.values()).filter(a -> a.code.equals(value)).findFirst();
    return first.isPresent();
  }
}
