package com.biz.crm.dms.business.policy.sdk.enums;

import lombok.Getter;

import java.util.Optional;
import java.util.stream.Stream;

/**
 * 系统支持的优惠政策模板中的商品选择方式
 * @author: yinwenjie
 * @date: 2021/12/10 10:23
 */
@Getter
public enum ProductSelectionMethod {

  /** 可购清单类型 */
  NOSELECT("noselect", "整单政策，禁用商品选择方式"),
  SINGLE("single", "多本品同一规则"),
  MULTIPLE("multiple", "多本品不同规则"),
  ;

  private String code;
  private String desc;

  ProductSelectionMethod(String code, String desc) {
    this.code = code;
    this.desc = desc;
  }

  public static Boolean exists(String value) {
    Optional<ProductSelectionMethod> first =
        Stream.of(ProductSelectionMethod.values()).filter(a -> a.code.equals(value)).findFirst();
    return first.isPresent();
  }
  
  /**
   * 通过商品选择规则到code信息，获得枚举信息
   * @param code
   * @return
   */
  public static ProductSelectionMethod getMethod(String code) {
    Optional<ProductSelectionMethod> first =
        Stream.of(ProductSelectionMethod.values()).filter(a -> a.code.equals(code)).findFirst();
    return first.orElse(null);
  }
}
