package com.biz.crm.dms.business.policy.sdk.enums;


import lombok.Getter;

import java.util.Optional;
import java.util.stream.Stream;

/**
 * @description: 选定方式：include：包括；exclude：排除
 * @author: songjingen
 * @date: 2021/12/10 10:23
 */
@Getter
public enum ScopeSelectionMethod {

  /** 可购清单类型 */
  INCLUDE("include", "包括"),
  EXCLUDE("exclude", "排除"),
  ;

  private String code;
  private String desc;

  ScopeSelectionMethod(String code, String desc) {
    this.code = code;
    this.desc = desc;
  }

  public static Boolean exists(String value) {
    Optional<ScopeSelectionMethod> first =
        Stream.of(ScopeSelectionMethod.values()).filter(a -> a.code.equals(value)).findFirst();
    return first.isPresent();
  }
}
