package com.biz.crm.dms.business.policy.sdk.event;

import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;

/**
 * 优惠政策功能相关的事件通知
 * @author yinwenjie
 */
public interface SalePolicyEventListener {
  /**
   * 当优惠政策信息被创建时，该事件被触发
   * @param salePolicy
   */
  public void onCreated(SalePolicyVo salePolicy);

  /**
   * 当优惠政策信息被修改时，该事件被触发
   * @param salePolicy
   */
  public void onUpdate(SalePolicyVo salePolicy);
  
  /**
   * 当优惠政策信息被删除时（逻辑删除），该事件被触发
   * @param salePolicy
   */
  public void onDeleted(SalePolicyVo salePolicy);
}