package com.biz.crm.dms.business.policy.sdk.event;

import com.biz.crm.dms.business.policy.sdk.dto.SalePolicyLogDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 销售政策模板日志事件监听器
 *
 * @author hefan
 * @date 2022/05/25
 */
public interface SalePolicyLogEventListener extends NebulaEvent {


  /**
   * 在创建
   *
   * @param salePolicyLogDto 销售政策日志dto
   */
  void onCreate(SalePolicyLogDto salePolicyLogDto);

  /**
   * 在更新
   *
   * @param salePolicyLogDto 销售政策日志dto
   */
  void onUpdate(SalePolicyLogDto salePolicyLogDto);

  /**
   * 在启用
   *
   * @param salePolicyLogDto 销售政策日志dto
   */
  void OnEnable(SalePolicyLogDto salePolicyLogDto);

  /**
   * 在禁用
   *
   * @param salePolicyLogDto 销售政策日志dto
   */
  void OnDisable(SalePolicyLogDto salePolicyLogDto);

  /**
   * 在删除
   *
   * @param salePolicyLogDto 销售政策日志dto
   */
  void OnDelete(SalePolicyLogDto salePolicyLogDto);
}
