package com.biz.crm.dms.business.policy.sdk.event;

import com.biz.crm.dms.business.policy.sdk.dto.SalePolicyTempleteLogDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 销售政策模板日志事件监听器
 *
 * @author hefan
 * @date 2022/05/25
 */
public interface SalePolicyTempleteLogEventListener extends NebulaEvent {


  /**
   * 在创建
   *
   * @param salePolicyTempleteLogDto 销售政策模板日志dto
   */
  void onCreate(SalePolicyTempleteLogDto salePolicyTempleteLogDto);

  /**
   * 在更新
   *
   * @param salePolicyTempleteLogDto 销售政策模板日志dto
   */
  void onUpdate(SalePolicyTempleteLogDto salePolicyTempleteLogDto);

  /**
   * 在启用
   *
   * @param salePolicyTempleteLogDto 销售政策模板日志dto
   */
  void OnEnable(SalePolicyTempleteLogDto salePolicyTempleteLogDto);

  /**
   * 在禁用
   *
   * @param salePolicyTempleteLogDto 销售政策模板日志dto
   */
  void OnDisable(SalePolicyTempleteLogDto salePolicyTempleteLogDto);

  /**
   * 在删除
   *
   * @param salePolicyTempleteLogDto 销售政策模板日志dto
   */
  void OnDelete(SalePolicyTempleteLogDto salePolicyTempleteLogDto);
}
