package com.biz.crm.dms.business.policy.sdk.register;

import java.util.Collection;

import com.biz.crm.dms.business.policy.sdk.characteristic.CharacteristicStrategy;
import com.biz.crm.dms.business.policy.sdk.enums.ProductSelectionMethod;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyStickupListener;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractCharacteristicInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyLimitInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyProductInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyThreshold;

/**
 * 具体的优惠政策模板实现注册接口（如果不清楚具体作用，请参见文档），
 * 注意，这里选择的都是这个优惠政策类型在各个要素维度能够使用的全部范围，但具体这个优惠政策可以使用什么样的要素范围，完全看创建优惠政策模块时的SalePolicyTempleteVo对象描述
 * @author yinwenjie
 */
public interface SalePolicyTempleteRegister {
  /**
   * 优惠政策模板类型，全系统唯一。<br>
   * 优惠政策类型和getTypeDesc()返回的说明信息是对应的，且本身也是全系统唯一的
   * @return
   */
  public String getType();
  /**
   * 场景信息的中文说明。</br>
   * 例如：商品——整单——满减
   * @return
   */
  public String getTypeDesc();
  /**
   * 注册器中的该方法，指示这个优惠政策是否是在商品维度进行了（例如按照商品折扣进行优惠）。
   * @return 如果返回true，则表示该优惠政策是基于商品来进行优惠的，这时这个注册器对应的SalePolicyStickupListener，必须返回具体的商品本品描述类型；</br>
   * 如果返回false，则表示该优惠政策是基于整个订单进行优惠的，这时这个注册器对应的SalePolicyStickupListener，不必返回具体的商品本品描述类型（AbstractSalePolicyProductInfo）
   */
  public Boolean supportProduct();
  /**
   * 该优惠政策类型能够支持的商品选择方式，注意，如果supportProduct()方法返回的是false，那么这里只能设定为NOSELECT；</br>
   * 如果supportProduct()方法返回的是true，则不能设定为NOSELECT
   * @return
   */
  public ProductSelectionMethod[] getProductSelectionMethods();
  /**
   * 返回具体的优惠政策数据运维策略（类型）
   */
  public SalePolicyStickupListener<? extends AbstractSalePolicyThreshold , ? extends AbstractSalePolicyProductInfo> getStickupListener();
  /**
   * 返回该优惠政策可以使用的特性执行策略</br>
   * 该策略是2022-05-30，新增的功能，所以默认返回null
   */
  public default Collection<Class<? extends CharacteristicStrategy<? extends AbstractCharacteristicInfo>>> getCharacteristicStrategyClasses() {
    return null;
  }
  /**
   * 返回该优惠政策可以使用的客户范围选择方式(注意，是可用的，不是具体优惠实例正在使用的)
   */
  public Collection<Class<? extends SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>>> getCustomerScopeStrategyClasses();
  /**
   * 返回这个优惠政策可绑定的（注意是可绑定的，而不是已经绑定的）政策限量信息
   * @return 
   */
  public Collection<Class<? extends SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo>>> getBindableLimitStrategyClasses();
  /**
   * 返回这个优惠政策可以使用的具体优惠政策执行方式，可以是多个，也可以是一个，但必须要有。(注意，是可用的，不是具体优惠实例正在使用的)
   * @return 
   */
  public Collection<Class<? extends SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo>>> getExecuteStrategyClasses(); 
}
