package com.biz.crm.dms.business.policy.sdk.service;

import java.util.Map;
import java.util.Set;

import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;

/**
 * 优惠政策执行/预执行服务
 * @author Administrator
 */
public interface SalePolicyExecuteService <T extends AbstractPolicyExecuteContext> {
  
  /**
   * 预判定执行。预判定场景无需知晓商品数量，不考虑优惠政策的门槛、不考虑订单总价，不考虑政策叠加、政策阶梯</br>
   * 预判定场景适用于商品列表展示功能、购物车列表展示功能
   * @param initPolicyProducts 要进行优惠活动计算的一批本品规格
   * @param tenantCode 经销商业务编号
   * @param customerCode 客户编号
   * @return
   */
  public T preJudgment(Set<SalePolicyConProduct> initPolicyProducts , String tenantCode , String customerCode);
  
  /**
   * 让一批商品规格，基于经销商为指定客户提供的正在执行中的活动策略进行预计算，最终得到这批物资在各个维度层面上的优惠信息
   * @param initPolicyProducts 要进行优惠活动计算的一批本品规格
   * @param tenantCode 经销商业务编号
   * @param customerCode 客户编号
   * @param kneading 是否需要在分摊优惠结果时，进行揉价
   * @return
   */
  public T preExecute(Set<SalePolicyConProduct> initPolicyProducts , String tenantCode , String customerCode, boolean kneading);
  
  /**
   * 让一批商品规格，基于经销商为指定客户提供的正在执行中的活动策略进行预计算，最终得到这批物资在各个维度层面上的优惠信息</br>
   * 这时，调用者可以指定一些本品不参与某些本身可以参与的优惠政策。但请注意，如果指定了某个本品参与其本身就不能参与的优惠政策，那么执行过程就会报错
   * @param initPolicyProducts 要进行优惠活动计算的一批本品规格
   * @param selectPolicyCodeMapping key：某个本品信息（必须存在于initPolicyProducts中）；V：这个本品指定参与的优惠政策，其余优惠政策都不参与
   * @param tenantCode 经销商业务编号
   * @param customerCode 客户编号
   * @param kneading 是否需要在分摊优惠结果时，进行揉价
   * @return
   */
  public T preExecute(Set<SalePolicyConProduct> initPolicyProducts , Map<String , String[]> selectPolicyCodeMapping , String tenantCode , String customerCode, boolean kneading);
  
  /**
   * 让一批商品规格，进行正式的优惠过程计算，最终得到这批物资在各个维度层面上的优惠信息</p>
   * 
   * 注意：</br>
   * 预计算和正式计算涉及几个关键的不同点：</br>
   * 1、正式计算需要关联外部单据，没有单据信息，计算就需要
   * 2、正式计算需要进行优惠结果的流水记录（主要有限量明细部分负责进行记录）
   * 
   * @param relevanceCode 外部单据——必须传入
   * @param initPolicyProducts 要进行优惠活动计算的一批本品规格
   * @param selectPolicyCodeMapping key：某个本品信息（必须存在于initPolicyProducts中）；V：这个本品指定参与的优惠政策，其余优惠政策都不参与
   * @param tenantCode 经销商业务编号
   * @param customerCode 客户编号
   * @param kneading 是否需要在分摊优惠结果时，进行揉价
   * @return 计算结果，将以运行上下文的形式返回给调用者
   */
  public T execute(String relevanceCode , Set<SalePolicyConProduct> initPolicyProducts , Map<String , String[]> selectPolicyCodeMapping , String tenantCode , String customerCode, boolean kneading);
  
  /**
   * 该方法按照指定的单据信息、租户信息和客户信息，查找历史上已完成优惠政策执行的结果（以上下文的情况返回）
   * @param relevanceCode 外部单据——必须传入
   * @param tenantCode 经销商业务编号
   * @param customerCode 客户编号
   * @return 历史的计算结果，将以运行上下文的形式返回给调用者，如果没有找到计算结果，则返回null
   */
  public T findByRelevanceCode(String relevanceCode , String tenantCode , String customerCode);
}
