package com.biz.crm.dms.business.policy.sdk.service;

import java.util.Set;

import org.springframework.data.domain.Pageable;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.policy.sdk.dto.SalePolicyPageDto;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;

public interface SalePolicyVoService {
  /**
   * 由于促销政策单使用创建授权标签来避免重复提交的问题。所以在创建/修改营销政策单前，需要使用该方法获得预授权</br>
   * 预授权成功后，才能通过预授权信息进行添加，
   * @return 
   */
  public String preSave();
  /**
   * 创建一个新的SalePolicy模型对象（包括了可能的第三方系统调用、复杂逻辑处理等）
   * @param salePolicyJson 注意，这里传递的是一个json信息，这也是http层接口应该调用的接口
   */
  public SalePolicyVo create(JSONObject salePolicyJson);
  /**
   * 创建一个新的SalePolicy模型对象（包括了可能的第三方系统调用、复杂逻辑处理等）
   */
  public SalePolicyVo create(SalePolicyVo salePolicy);
  /**
   * 更新一个已有的SalePolicy模型对象，其主键属性必须有值。
   * @param salePolicyJson 注意，这里传递的是一个json信息，这也是http层接口应该调用的接口
   * @return
   */
  public SalePolicyVo update(JSONObject salePolicyJson);
  /**
   * 更新一个已有的SalePolicy模型对象，其主键属性必须有值。
   * 这个方法实际上应该有一共分为三个步骤（默认）：</br>
   * 1、调用updateValidation方法完成表单数据更新前的验证</br>
   * 2、正式进行基本信息的表单数据的更新</br>
   * 3、关联完成具体扩展信息的更新
   */
  public SalePolicyVo update(SalePolicyVo salePolicy);
  /**
   * 将指定的多个促销政策下架（也就是将effective标记设置为false）
   * @param salePolicyCode 促销政策指定的业务编号
   */
  public void invalid(String[] salePolicyCodes);
  /**
   * 将指定的多个促销政策上架（也就是将effective标记设置为true）
   * @param salePolicyCode 促销政策指定的业务编号
   */
  public void effective(String[] salePolicyCodes);
  /**
   * 该方法可用于物理删除指定的优惠政策，但是只有那些没有开始执行、没有关联优惠政策执行流水的优惠政策，可以被删除
   * @param salePolicyCode
   */
  public void deleteBySalePolicyCode(String salePolicyCode);
  
  // ========= 以下都是查询信息（都是从缓存查询）
  
  /**
   * 按照指定的销售策略/政策的业务编号，从缓存查询当前经销商下的信息详情（包括各种关联信息和冗余信息）。
   * 注意，由于该优惠政策信息不一定存在于缓存中，所以如果发现其不在缓存中，则可以根据第二个参数，试图从数据层直接查找
   * @return 
   */
  public SalePolicyVo findDetailsByCode(String salePolicyCode);
  /**
   * 从缓存中查询，截止当前时间点未开始的或者进行中的所有营销活动信息，并按照开始时间进行排列
   * @param tenantCode 指定的经销商
   * @param processing 为true是只查询当前正在进行的，为false表示查询当前进行中和未开始的
   * @return
   */
  public Set<SalePolicyVo> findDetailsByProcessing(boolean processing);
  /**
   * 在findDetailsByEffective基础上，查询和指定客户匹配的营销正在进行的活动信息。 
   * @param tenantCode 指定的经销商 
   * @param processing 为true是只查询当前正在进行的，为false表示查询当前进行中和未开始的 
   * @param customerCode 指定的客户业务编号信息 
   * @return 
   */
  public Set<SalePolicyVo> findDetailsByProcessingAndCustomerCode(String tenantCode , boolean processing , String customerCode , String relevanceCode);
  /**
   * 基于目前正在运行和将要运行的营销活动，查询特定的一个规格编码，特定一个客户，匹配哪些营销活动信息
   * @param tenantCode 指定的二级租户
   * @param processing 为true是只查询当前正在进行的，为false表示查询当前进行中和未开始的 
   * @param customerCode 指定的客户编码
   * @param productCodes 指定的商品编码(可以或者多个)
   */
  public Set<SalePolicyVo> findDetailsByProcessingAndCustomerCodesAndProductCodes(String tenantCode , boolean processing , String customerCode, String relevanceCode , String... productCodes);
  
  // ======= 以下是查询信息（都直接来自于数据层）
  
  /**
   * 针对特定二级租户的已存在的优惠政策分页查询信息（）
   * @param page 分页信息 
   * @param dto  分页参数dto
   * @return 分页列表
   */
  public Page<SalePolicyVo> findByConditions(Pageable pageable, SalePolicyPageDto dto);
}
