package com.biz.crm.dms.business.policy.sdk.strategy;

import java.util.List;

import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;

/**
 * 优惠政策作用范围合并策略，通过该策略的实现，开发人员可以决定某一个优惠政策中，当多个客户选择返回起作用时；
 * 如何进行最终匹配客户范围的确认；标品中已经实现了取“并集”的实现，如果有必要可自行实现取“交集”的实现或者其它更另类的实现
 * @author yinwenjie
 */
public interface SalePolicyCustomerScopeMergeStrategy {
  /**
   * 进行以确定的两组客户匹配情况的合并。举例：
   * @param historyMatched 历史上已经完成的用户范围匹配结果
   * @param size 当前指定用户currentCustomerCode在指定的优惠政策上currentSalePolicyVo，需要匹配的用户范围次数，至少为1
   * @param currentSalePolicyVo 当前的优惠政策
   * @param currentCustomerCode 本次要进行合并的客户范围集合（客户编号）
   * @param currentMatched 当前最新一次用户范围匹配结果，false：表示没有匹配成功；true表示匹配成功
   * @param currentScopeType 当前正在匹配的用户范围类型（参见各个具体的SalePolicyCustomerScopeStrategy接口实现）
   * @return 如果返回false，则表示当前指定用户currentCustomerCode和指定的优惠政策currentSalePolicyVo匹配完全失败；
   */
  public MergeResult merge(List<Boolean> historyMatched , int size , SalePolicyVo currentSalePolicyVo , String currentCustomerCode , boolean currentMatched , String currentScopeType);
  
  /**
   * 匹配结果：</br>
   * UNDETERMINED：未确认：经过本次用户和用户范围匹配维度的执行，仍然不能确定用户和优惠政策是否匹配成功</br>
   * SUCCEEDED：已成功：经过本次用户和用户范围匹配维度的执行，已经确认匹配成功</br>
   * FAILED：以失败：经过本次用户和用户范围匹配维度的执行，已经确认匹配失败
   * @author yinwenjie
   */
  public enum MergeResult {
    UNDETERMINED,
    SUCCEEDED,
    FAILED
  }
}
