package com.biz.crm.dms.business.policy.sdk.strategy;

import java.util.Set;

import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;

/**
 * 优惠政策可以使用的客户范围选择策略，每一个SalePolicyCustomerScopeStrategy接口的实现，就是一个具体的客户范围控制策略
 * @author yinwenjie
 */
public interface SalePolicyCustomerScopeStrategy<C extends AbstractSalePolicyCustomerScopeInfo> {
  /**
   * 这个方法将返回这个具体客户范围控制策略的全系统唯一类型编号，注意：如果系统中类型编号重复，则系统启动时会报错
   * @return
   */
  public String getScopeType();
  /**
   * 该方法将返回这个具体客户范围控制策略的中文说明信息
   * @return
   */
  public String getScopeTypeDesc();
  /**
   * 返回当前具体优惠政策实现所使用的具体客户范围描述类
   */
  public Class<C> getSalePolicyCustomerInfoClass();
  
  // ========= 以下需要实现的方法，是和关联的客户圈定范围数据维护相关的
  
  /**
   * 当需要具体的客户范围选择政策需要进行已设置信息的维护时（可能是新增也可能是修改），该方法会被触发
   * @param update 表示当前优惠政策信息是被创建还是被修改，true表示是修改；其它值表示是创建
   * @param currentSalePolicy 当前正在进行维护的优惠政策基本信息（且这个基本信息已经维护成功）
   * @param oldSalePolicy 如果update为true，那么oldSalePolicy描述了修改前的优惠政策详细信息（包括所有的关联信息）
   */
  public void onSaveSalePolicyCustomerInfo(boolean update , SalePolicyVo currentSalePolicy , SalePolicyVo oldSalePolicy);
  /**
   * 当需要具体的客户范围选择政策中，对应的业务发生启用时（例如经销商被启用、组织机构被启用），该方法会被触发
   * @param tenantCode 相关的二级租户信息
   * @param codes 业务编码信息
   */
  public void onEffective(String tenantCode , String[] codes);
  /**
   * 当需要具体的客户范围选择政策中，对应的业务发生禁用时（例如经销商被禁用、组织机构被禁用），该方法会被触发
   * @param tenantCode 相关的二级租户信息
   * @param codes 业务编码信息
   */
  public void onInvalid(String tenantCode , String[] codes);
  /**
   * 当需要具体的客户范围选择政策中，对应的业务发生删除时（例如经销商被删除、组织机构被删除），该方法会被触发
   * @param tenantCode 相关的二级租户信息
   * @param codes 业务编码信息
   */
  public void onDelete(String tenantCode , String[] codes);
  
  // ========== 以下需要实现的方法，是和具体的匹配过程有关的
  
  /**
   * 当有一个具体优惠政策需要构造具体客户范围描述的时候，该方法会被触发
   * @param tenantCode 指定的二级租户信息
   * @param salePolicyCode 当前构造的具体优惠政策业务编号
   * @return 
   */
  public Set<C> requestSalePolicyCustomerInfo(String tenantCode , String salePolicyCode);
  /**
   * 当系统需要基于某个客户范围选择策略，寻找特定优惠政策的可用客户范围（业务编号），该方法将被触发
   * @param tenantCode 当前二级租户信息
   * @param salePolicyCode 需要查询的优惠政策业务编号
   * @return 实现者需要将匹配的一个或者多个客户（例如经销商）业务编号进行返回
   */
  public boolean matched(String customerCode , String tenantCode , String salePolicyCode , Set<C> salePolicyCustomerInfos);
}
