package com.biz.crm.dms.business.policy.sdk.strategy;

import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;

/**
 * 优惠政策执行时，可以使用的阶梯循环规则，例如：</br>
 * 阶梯叠加买赠 (满足多个坎级则叠加赠送：例如：每满50箱送2箱，每满100箱送6箱。若单笔订单为250箱，则送2*6+1*2=14箱。)</p>
 * @author yinwenjie
 */
public interface SalePolicyCycleRuleStrategy {
  /**
   * 这个方法将返回这个阶梯循环规则的唯一业务编号，注意：如果系统中该编号重复，则系统启动时会报错
   * @return
   */
  public String getCycleRuleCode();
  /**
   * 这个方法将返回这个阶梯循环规则的中文描述</br>
   * 例如：“单阶梯”
   * @return
   */
  public String getCycleRuleDesc();
  
  // ======== 继续完善执行部分的接口要求
  
  /**
   * 正式的阶梯控制方法在这里，TODO 完善注释
   */
  public void cycle(AbstractCycleExecuteContext cycleExecuteContext , SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> salePolicyExecuteStrategy , SalePolicyVo currentSalePolicy , AbstractSalePolicyExecutorInfo correctExecutorInfo);
}
