package com.biz.crm.dms.business.policy.sdk.strategy;

import java.util.Set;

import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;

/**
 * 优惠政策执行后的分摊策略，根据优惠政策执行策略不同，执行后所使用的分摊策略也不同。
 * 所以，最终怎么使用优惠后的分摊策略和使用的哪种优惠政策执行相关，那么分摊政策的设定需要在优惠政策执行策略设置时，同时完成</p>
 * 
 * 目前分摊策略有以下几种：</br>
 * a、将优惠后的金额，基于各个参与优惠的商品明细在优惠前的小计金额比例，分摊到商品小计上（且需要支持揉价和不揉价两种模式）。</br>
 * b、将优惠后的赠品数量，基于各个参与优惠的商品明细在优惠前的小计金额比例，分摊到商品对应的赠品上。</br>
 * c、将优惠后的赠品数量，基于各个参与优惠的商品明细在优惠前的数量比例，分摊到商品对应的赠品上。</br>
 * 
 * @author yinwenjie
 */
public interface SalePolicyExecuteShareStrategy {
  
  /**
   * 某个优惠政策执行后（实际上是这个优惠政策的所有阶梯执行后），优惠政策的结果需要按照一定的策略，将优惠结果分摊到参与优惠的每个商品上</br>
   * 或者换句话说也行：需要按照本次优惠政策的执行结果上下文cycleExecuteContext，构造最新的整体优惠政策执行上下文policyExecuteContext
   * @param customerCode 优惠政策涉及的客户业务编号信息
   * @param salePolicy 优惠政策基本数据信息（包括各种关联信息），并不要进行任何信息的修改，只进行只读操作
   * @param policyExecuteContext 整体优惠政策执行上下文
   * @param cycleExecuteContext 本次优惠政策的执行结果上下文
   * @param productCodes
   */
  public void share(String customer , SalePolicyVo salePolicy ,  AbstractPolicyExecuteContext policyExecuteContext , AbstractCycleExecuteContext cycleExecuteContext , Set<String> productCodes);
  
}
