package com.biz.crm.dms.business.policy.sdk.strategy;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;

/**
 * 优惠政策规则执行策略，即正式执行“每满100，减30的优惠政策”这一需求点，系统中有多少优惠政策详细规则，当然就对应多少SalePolicyExecuteStrategy接口的具体实现</p>
 * 
 * 另外，需要注意，每一个SalePolicyExecuteStrategy接口的具体实现，其业务编号都必须是全系统唯一的
 * 
 * @author yinwenjie
 *
 */
public interface SalePolicyExecuteStrategy <R extends AbstractSalePolicyExecutorInfo> {
  /**
   * 这个方法将返回这个具体执行策略的全系统唯一业务编号，注意：如果业务编号重复，则系统启动时会报错
   */
  public String getExecuteStrategyCode();
  /**
   * 该方法将返回这个具体执行策略的中文说明信息
   */
  public String getExecuteStrategyDesc();
  /**
   * 该方法将返回这个具体执行策略的页面显示内容表达式，表达式的说明如下：</br>
   */
  public String getExpression();
  /**
   * 返回当前具体优惠政策实现所使用的具体优惠政策逻辑描述类
   */
  public Class<R> getSalePolicyExecutorInfoClass();
  /**
   * 返回当前执行策略采用的分摊策略，详细说明请参见{@link SalePolicyExecuteShareStrategy}接口
   * @return
   */
  public Class<? extends SalePolicyExecuteShareStrategy> getSalePolicyExecuteShareStrategy();
  /**
   * 返回这个优惠政策执行策略可以使用的具体“阶梯循环规则”。
   * @return
   */
  public Collection<Class<? extends SalePolicyCycleRuleStrategy>> getCycleRuleStrategyClasses();
  /**
   * 该方法用于返回在当前优惠政策执行策略下，特定的循环执行方式的执行效果描述，
   * 以便于设置者能够明确最后的设置效果。</br>
   * 例如：每满50箱送2箱，每满100箱送6箱。若单笔订单为250箱，则送2*6+5*2=22箱
   * @param cycleRuleCode 指定的循环优惠策略
   * @return 
   */
  public String getCycleRuleExample(String cycleRuleCode);
  /**
   * 当有一个具体优惠政策需要构造具体优惠政策逻辑描述的时候，该方法会被触发
   * @param tenantCode 二级租户信息
   * @param salePolicyCode 当前构造的具体优惠政策业务编号
   * @return 
   */
  public List<R> onRequestSalePolicyExecutorInfo(String tenantCode , String salePolicyCode);
  /**
   * 当需要具体的优惠政策进行促销政策执行规则信息的维护时（可能是新增也可能是修改），该方法会被触发
   * @param update 表示当前优惠政策信息是被创建还是被修改，true表示是修改；其它值表示是创建
   * @param currentSalePolicy 当前正在进行维护的优惠政策基本信息（且这个基本信息已经维护成功）
   * @param oldSalePolicy 如果update为true，那么oldSalePolicy描述了修改前的优惠政策详细信息（包括所有的关联信息）
   * @param salePolicyExecutorInfos 当前需要维护的特定促销政策执行规则信息(至少一个)
   */
  public void onSaveSalePolicyExecutorInfo(boolean update , SalePolicyVo currentSalePolicy , SalePolicyVo oldSalePolicy);
  
  // ======= 以下的方法定义和具体的执行过程有关
  
  /**
   * 该方法用于为策略执行器创建阶梯循环执行策略（不同的优惠策略执行过程，所需要记录的上下文数据情况可能完全不一样）</br>
   * 例如标品中的商品-满折、商品-单价满减、商品-赠品满赠，这几种优惠政策在执行阶梯的过程中，需要记录的信息完全不一样
   * @param executeContext 当前的优惠政策执行上下文
   * @param executorCode 本次步进执行所使用的优惠政策中的具体执行器
   * @param initPolicyProducts 参与本次优惠的所有本品物资
   * @param customerCode 当前进行优惠的客户信息
   */
  public AbstractCycleExecuteContext buildCycleExecuteContext(AbstractPolicyExecuteContext executeContext , String executorCode , Set<SalePolicyConProduct> initPolicyProducts , String customerCode);
  
  /**
   * 该方法用于执行第index级阶梯，在目前最新的优惠政策执行状态下，是否还能继续进行优惠
   * @param index 阶梯级别，从0开始
   * @param times 这是本优惠政策政策（执行器）的第几次执行，从1开始
   * @param correctAbstractExecutorInfo 当前正在执行的优惠政策执行器信息
   * @param cycleExecuteContext 当前最新的阶梯执行上下文
   * @return 如果当前参与优惠的本品/赠品情况，满足阶梯执行要求，并且执行成功，则返回true，其它情况返回false
   */
  public boolean execute(AbstractCycleExecuteContext cycleExecuteContext , int index , int times , AbstractSalePolicyExecutorInfo correctAbstractExecutorInfo);
}
