package com.biz.crm.dms.business.policy.sdk.strategy;

import java.util.Map;
import java.util.Set;

import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;

/**
 * 赠品询价策略，赠品询价策略一定依赖CRM中的价格体系；但如何进行询价，则有具体项目进行实现；</p>
 * 在CRM3.0中有一个默认的询价策略实现，多数情况下是满足要求的
 * @author yinwenjie
 */
public interface SalePolicyGiftInquiryStrategy {
  /**
   * 进行询价
   * @param customerCode 当前订单或者业务单据的客户编号
   * @param giftCodes 当前进行询价的商品/赠品 编号（一般来说是赠品信息）
   * @param salePolicy 当前进行询价的优惠政策信息
   * @return 注意返回值，返回值是一个K-V形式的Map结构；其中Key表示商品/赠品编号；Value表示询价结果（具体对象意义请参考PriceModelVo类中的描述）
   */
  public Map<String, PriceModelVo> inquiry(String customerCode , Set<String> giftCodes , SalePolicyVo salePolicy);
}
