package com.biz.crm.dms.business.policy.sdk.strategy;

import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyLimitInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;

/**
 * 优惠政策可使用的限量控制策略，每一个SalePolicyLimitStrategy接口的实现，就是一个具体的限量控制策略
 * @author yinwenjie
 */
public interface SalePolicyLimitStrategy <L extends AbstractSalePolicyLimitInfo> {
  /**
   * 这个方法将返回这个具体限量控制策略的全系统唯一业务编号，注意：如果业务编号重复，则系统启动时会报错
   */
  public String getLimitStrategyCode();
  /**
   * 该方法将返回这个具体限量控制策略的中文说明信息
   */
  public String getLimitStrategyDesc();
  /**
   * 该方法将返回这个具体限量控制策略的页面显示内容表达式。</br>
   * 可参见 {@link SalePolicyLimitStrategy} 接口中的表达式要求
   */
  public String getExpression();
  /**
   * 返回具体限量政策使用的具体对象描述信息
   */
  public Class<L> getSalePolicyLimitInfoClass();
  /**
   * 当有一个具体优惠政策需要构造具体限量控制描述的时候，该方法会被触发（注意，这里需要返回的是当前优惠政策已经绑定的限量门槛，而不是可以绑定的限量门槛）
   * @param salePolicyCode 当前构造的具体优惠政策业务编号
   * @return 
   */
  public L onRequestSalePolicyLimitInfos(String salePolicyCode);
  /**
   * 当需要具体的优惠政策进行绑定的一个或多个限量政策信息的维护时（可能是新增也可能是修改），该方法会被触发
   * @param update 表示当前优惠政策信息是被创建还是被修改，true表示是修改；其它值表示是创建
   * @param currentSalePolicy 当前正在进行维护的优惠政策基本信息（且这个基本信息已经维护成功）
   * @param oldSalePolicy 如果update为true，那么oldSalePolicy描述了修改前的优惠政策详细信息（包括所有的关联信息）
   */
  public void onSaveSalePolicyLimitInfos(boolean update , SalePolicyVo currentSalePolicy , SalePolicyVo oldSalePolicy);
  
  //======= 以下实现方法和优惠政策限量政策执行有关
  
  /**
   * 各限量控制逻辑预验证的方法实现。预验证逻辑和正式验证逻辑（validate）的却别在于：当诸如订单展现时，这时实际上这个订单还没有正式下单，预验证过程会被激活，
   * 在这个过程中各限量逻辑只需要验证，无需将验证结果记录在业务流水中。
   * @param policyExecuteContext
   * @param cycleExecuteContext 本次限量政策执行设计到的阶梯步进上下文
   * @param currentSalePolicy 当前正在执行的优惠政策信息
   * @param salePolicyLimitInfo 当前正在执行的限量政策信息
   */
  public void preValidate(AbstractPolicyExecuteContext policyExecuteContext , AbstractCycleExecuteContext cycleExecuteContext, SalePolicyVo currentSalePolicy, AbstractSalePolicyLimitInfo salePolicyLimitInfo);
  
  /**
   * 参见preValidate方法的说明
   * @param policyExecuteContext
   * @param cycleExecuteContext 本次限量政策执行设计到的阶梯步进上下文
   * @param currentSalePolicy 当前正在执行的优惠政策信息
   * @param salePolicyLimitInfo 当前正在执行的限量政策信息
   */
  public void validate(AbstractPolicyExecuteContext policyExecuteContext, AbstractCycleExecuteContext cycleExecuteContext, SalePolicyVo currentSalePolicy , AbstractSalePolicyLimitInfo salePolicyLimitInfo);
}
