package com.biz.crm.dms.business.policy.sdk.strategy;

import java.util.Set;

import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;

/**
 * 该策略专门负责在预执行/执行过程中，完成指定优惠政策“是否能在某个订单中执行”的匹配过程</p>
 * 
 * 该策略在标品中提供了一个默认实现，既是：只要这个优惠政策正常，且没有过期。那么只要订单的下单客户匹配，就认为优惠政策匹配</p>
 * 
 * 在实际的项目过程，二开团队经常需要更改该策略，例如：按照订单中的工厂和客户，进行特定优惠政策的匹配
 * 
 * @author yinwenjie
 */
public interface SalePolicyMatchedStrategy {
  /**
   * 一旦优惠政策在预执行或者执行时，需要匹配指定的优惠政策是否能被当前订单使用时，该方法会被触发；
   * 开发人员可以定义自己的逻辑（往往是匹配维度），来确认以上事实。
   * @param currentSalePolices 当前需要被判定的(一个或者多个)优惠政策；注意该优惠政策不可能是禁用的，但有可能是过期的或者未到执行期的；开发人员需要自己进行判定
   * @param tenantCode 当前租户信息。如果项目不涉及多租户，则该参数的传值一定为default
   * @param processing 为true是只查询当前正在进行的，为false表示查询当前进行中和未开始的;这个参数的意义在于，一些项目在商品列表页面，要求商品在未来将要进行的优惠，也要被展示出来；</br>
   * 那么自定义实现的需求没有这样的要求，则可以忽略该参数
   * @param relevanceCode 如果是正式执行，则必然有传入的单据的业务编码信息；如果是预执行，则relevanceCode可能没有值
   * @param customerCode 指定的客户业务编号信息
   * @return 如果经过判定，该优惠政策能够在该单据中使用，则返回true；其它情况返回false
   */
  public Set<SalePolicyVo> match(Set<SalePolicyVo> currentSalePolices , String tenantCode, boolean processing, String customerCode , String relevanceCode);
  
  /**
   * 该方法属于match方法的一个多态形式，多出来的productCodes数组，是要在match方法的维度，再增加对特定商品（SKU）的限制
   * @param productCodes 本次需要匹配的一批商品信息
   */
  public Set<SalePolicyVo> match(Set<SalePolicyVo> currentSalePolices , String tenantCode, boolean processing, String customerCode , String relevanceCode , String... productCodes);
}
