package com.biz.crm.dms.business.policy.sdk.strategy;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.tuple.Pair;

import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyProductInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyThreshold;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;

/**
 * 优惠政策数据维护策略，不同的具体优惠政策都需要有数据维护策略，这是因为不同的优惠政策除了优惠政策的基本信息一致外，其它的关联信息可能都不一样。</br>
 * 所以具体的优惠策略实现必须告知，模块基座，自己怎么去维护特定的扩展信息（例如，在进行了优惠政策添加后，怎么进行商品信息的添加等等）
 * @author yinwenjie
 */
public interface SalePolicyStickupListener<T extends AbstractSalePolicyThreshold , P extends AbstractSalePolicyProductInfo> {
  /**
   * 一个新的优惠政策维护监听器，需要注册一个明确的优惠政策门槛模型
   * @return
   */
  public Class<T> getSalePolicyProductThresholdClass();
  /**
   * 当优惠政策详情需要组装时，该方法会被触发，以便完成优惠政策优惠门槛部分的信息组装
   * @return
   */
  public T onRequestSalePolicyThreshold(String tenantCode , String salePolicyCode);
  /**
   * 当优惠政策被创建或者被修改是，该方法会被触发，用以维护优惠政策中的门槛信息
   * 注意，这里方法名的save代表，可能是进行salePolicyProductThreshold信息的创建，也可能是进行salePolicyProductThreshold信息的修改
   * @param update 表示当前优惠政策信息是被创建还是被修改，true表示是修改；其它值表示是创建
   * @param currentSalePolicy 当前正在进行维护的优惠政策基本信息（且这个基本信息已经维护成功）
   * @param oldSalePolicy 如果update为true，那么oldSalePolicy描述了修改前的优惠政策详细信息（包括所有的关联信息）
   * @param salePolicyThreshold 需要由实现者进行维护的优惠政策门槛信息
   */
  public void onSaveSalePolicyProductThreshold(boolean update , SalePolicyVo currentSalePolicy , SalePolicyVo oldSalePolicy , T salePolicyThreshold);
  
  /**
   * 该方法在需要优惠门槛被执行时触发，用来判定一批优惠执行本品，是否符合执行门槛条件。
   * @param policyConProducts 
   * @param salePolicyThreshold
   * @return TODO 这里返回值还需要进行描述 
   * 如果这批优惠执行本品不符合执行条件，则返回null或者空集合即可；如果这批本品的所有商品或者部分商品符合优惠政策的执行门槛，则按照如下映射关系进行返回：</br>
   * Key：匹配的门槛明细业务编号</br>
   * Value：在这个门槛明细下，哪些商品本品（的业务编码）被匹配成功，注意，这些商品一定存在于最初的policyConProducts集合中。
   */
  public Pair<Map<String, Set<String>>, String> executeThreshold(Set<SalePolicyConProduct> policyConProducts , AbstractPolicyExecuteContext executeContext , AbstractSalePolicyThreshold  salePolicyThreshold);
  
  // ======== 以下接口和商品本品有关
  
  /**
   * 返回当前具体优惠政策实现所使用的具体商品信息描述类
   */
  public Class<P> getSalePolicyProductInfoClass();
  /**
   * 当有一个具体优惠政策需要构造具体的商品信息的时候，该方法会被触发
   * @param tenantCode 二级租户信息
   * @param salePolicyCode 当前构造的具体优惠政策业务编号
   * @return 
   */
  public List<P> onRequestSalePolicyProductInfos(String tenantCode , String salePolicyCode);
  /**
   * 当需要具体的优惠政策进行促销商品信息的维护时（可能是新增也可能是修改），该方法会被触发
   * @param update 表示当前优惠政策信息是被创建还是被修改，true表示是修改；其它值表示是创建
   * @param currentSalePolicy 当前正在进行维护的优惠政策基本信息（且这个基本信息已经维护成功）
   * @param oldSalePolicy 如果update为true，那么oldSalePolicy描述了修改前的优惠政策详细信息（包括所有的关联信息）
   * @param salePolicyProductInfo 当前需要维护的特定促销商品信息
   */
  public void onSaveSalePolicyProductInfo(boolean update , SalePolicyVo currentSalePolicyVo , SalePolicyVo oldSalePolicy , Set<P> salePolicyProductInfos);
}
