package com.biz.crm.dms.business.policy.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 抽象的执行特性信息
 * @author yinwenjie
 */
@Getter
@Setter
@ApiModel(value = "AbstractCharacteristicInfo", description = "抽象的执行特性信息")
public abstract class AbstractCharacteristicInfo extends UuidVo {
  private static final long serialVersionUID = 49187457846132623L;
  @ApiModelProperty("优惠政策涉及的二级租户信息")
  private String tenantCode;
  /**
   * 优惠政策业务编号
   */
  @ApiModelProperty("优惠政策业务编号")
  private String salePolicyCode;
  /**
   * 特性执行编号（对应某个CharacteristicStrategy接口的具体实现类，characteristicCode()方法所返回的值）
   */
  @ApiModelProperty("特性执行编号（对应某个CharacteristicStrategy接口的具体实现类，characteristicCode()方法所返回的值）")
  private String characteristicCode;
}
