package com.biz.crm.dms.business.policy.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 抽象的优惠策略客户范围部分的信息描述
 * @author yinwenjie
 */
@ApiModel(value = "AbstractSalePolicyCustomerScopeInfo", description = "抽象的优惠策略客户范围部分的信息描述")
public abstract class AbstractSalePolicyCustomerScopeInfo extends UuidVo {
  private static final long serialVersionUID = 3095033854458502838L;
  @ApiModelProperty("优惠政策涉及的二级租户信息")
  private String tenantCode;
  
  @ApiModelProperty("优惠政策业务编号")
  private String salePolicyCode;
  
  @ApiModelProperty("当前优惠政策所使用的客户范围圈定方式,来自于SalePolicyCustomerScopeStrategy接口具体实现中的getScopeType()方法的返回值")
  private String customerScopeType;
  
  @ApiModelProperty(name="state" , value = "设定状态：0：禁用/废弃；1：正常")
  private Integer state = 1;

  /**
   * 需要返回的这个业务维度的编号，例如如果是按照组织机构确认的客户范围，这里就返回组织机构的code
   * @return
   */
  public abstract String scopeCode();
  
  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  public String getSalePolicyCode() {
    return salePolicyCode;
  }

  public void setSalePolicyCode(String salePolicyCode) {
    this.salePolicyCode = salePolicyCode;
  }

  public String getCustomerScopeType() {
    return customerScopeType;
  }

  public void setCustomerScopeType(String customerScopeType) {
    this.customerScopeType = customerScopeType;
  }

  public Integer getState() {
    return state;
  }

  public void setState(Integer state) {
    this.state = state;
  }
}
