package com.biz.crm.dms.business.policy.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 抽象的优惠政策执行信息部分
 * @author yinwenjie
 */
@Getter
@Setter
@ApiModel(value = "AbstractSalePolicyExecutorInfo", description = "抽象的优惠政策信息部分")
public abstract class AbstractSalePolicyExecutorInfo extends UuidVo {
  private static final long serialVersionUID = 4299110136946132623L;
  
  @ApiModelProperty("这条优惠政策执行规则所使用的执行器编码，该编码和某个SalePolicyExecuteStrategy接口具体实现类中的getExecuteStrategyCode()方法返回的值对应。")
  private String executeStrategyCode;
  
  @ApiModelProperty("优惠政策涉及的二级租户信息")
  private String tenantCode;
  
  @ApiModelProperty("优惠政策业务编号")
  private String salePolicyCode;
  
  @ApiModelProperty("优惠政策执行策略业务编码，全系统唯一。可以直接使用salePolicyCode，也可以使用商品编号+salePolicyCode。反正需要保证全系统唯一")
  private String executorCode;
  
  @ApiModelProperty("优惠政策选定的“阶梯循环规则”，参见SalePolicyCycleRuleStrategy接口的具体描述")
  private String cycleRuleCode;
}
