package com.biz.crm.dms.business.policy.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 抽象的限量政策信息
 * @author yinwenjie
 */
@ApiModel(value = "AbstractSalePolicyLimitInfo", description = "抽象的优惠政策信息部分")
@Getter
@Setter
public abstract class AbstractSalePolicyLimitInfo extends UuidVo {
  private static final long serialVersionUID = 4299110136946132623L;
  @ApiModelProperty("优惠政策涉及的二级租户信息")
  private String tenantCode;
  /**
   * 优惠政策业务编号
   */
  @ApiModelProperty("优惠政策业务编号")
  private String salePolicyCode;
  /**
   * 限量政策业务编号（对应某个SalePolicyLimitStrategy接口的具体实现类，getLimitStrategyCode()方法所返回的值）
   */
  @ApiModelProperty("限量政策业务编号（对应某个SalePolicyLimitStrategy接口的具体实现类，getLimitStrategyCode()方法所返回的值）")
  private String limitStrategyCode;
}
