package com.biz.crm.dms.business.policy.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 抽象的优惠策略商品部分的信息描述
 * @author yinwenjie
 */
@ApiModel(value = "AbstractSalePolicyProductInfo", description = "抽象的优惠策略商品部分的信息描述")
public abstract class AbstractSalePolicyProductInfo extends UuidVo {
  private static final long serialVersionUID = 3095033854458502838L;
  @ApiModelProperty("优惠政策涉及的二级租户信息")
  private String tenantCode;
  
  @ApiModelProperty("优惠政策业务编号")
  private String salePolicyCode;
  
  @ApiModelProperty("关联到优惠政策执行策略业务编码（来自于SalePolicyExecutorVo中的executorCode属性值）")
  private String executorCode;
  
  @ApiModelProperty("商品编码")
  private String productCode;

  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  public String getSalePolicyCode() {
    return salePolicyCode;
  }

  public void setSalePolicyCode(String salePolicyCode) {
    this.salePolicyCode = salePolicyCode;
  }

  public String getExecutorCode() {
    return executorCode;
  }

  public void setExecutorCode(String executorCode) {
    this.executorCode = executorCode;
  }

  public String getProductCode() {
    return productCode;
  }

  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }
}
