package com.biz.crm.dms.business.policy.sdk.vo;
import com.biz.crm.business.common.sdk.vo.UuidVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 抽象的优惠策略商品优惠门槛部分的信息描述（一个优惠政策有且必有一个门槛，但可以有完全不同的明细信息）
 * @author yinwenjie
 */
@ApiModel(value = "AbstractSalePolicyProductThreshold", description = "抽象的优惠策略商品优惠门槛部分的信息描述")
public abstract class AbstractSalePolicyThreshold extends UuidVo {
  private static final long serialVersionUID = -8748043270126977060L;
  
  @ApiModelProperty("优惠政策设计的二级租户信息")
  private String tenantCode;
  
  @ApiModelProperty("优惠政策业务编号")
  private String salePolicyCode;

  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  public String getSalePolicyCode() {
    return salePolicyCode;
  }

  public void setSalePolicyCode(String salePolicyCode) {
    this.salePolicyCode = salePolicyCode;
  }
}
