package com.biz.crm.dms.business.policy.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Set;

/**
 * 促销政策/优惠政策 规则模板，这个模板记录了创建优惠政策实例前，优惠政策能够框定的各种要素的最大范围。</p>
 * 例如，商品-满减 优惠政策类型，有哪些最大范围可选的优惠政策执行策略、有哪些最大范围可选的优惠政策阶梯循环策略、有哪些
 * 
 * @author yinwenjie
 */
@Setter
@Getter
public class SalePolicyTempleteVo extends TenantFlagOpVo {
  private static final long serialVersionUID = -4092545401943050193L;
  /**
   * 关键的优惠政策模板类型（编号），匹配不同的SalePolicyTempleteRegister接口实现中getType()方法返回的值
   */
  @ApiModelProperty("关键的优惠政策类型（编号），匹配不同的SalePolicyTempleteRegister接口实现中getType()方法返回的值")
  private String type;
  /**
   * 关键的优惠政策类型中文名称，匹配不同的SalePolicyTempleteRegister接口实现中getTypeDesc()方法返回的值
   */
  @ApiModelProperty("关键的优惠政策类型中文名称，匹配不同的SalePolicyTempleteRegister接口实现中getTypeDesc()方法返回的值")
  private String typeDesc;
  /**
   * 促销模板编码（必须输入，保证全系统唯一）
   */
  @ApiModelProperty("促销模板编码（必须输入，保证全系统唯一）")
  private String templeteCode;
  /**
   * 促销模板名称
   */
  @ApiModelProperty("促销模板名称")
  private String templeteName;
  /**
   * 该优惠政策模板是否支持关联预算信息
   */
  @ApiModelProperty("该优惠政策模板是否支持关联预算信息")
  private Boolean supportBudget;
  
  @ApiModelProperty("该优惠政策已经绑定的可使用的执行特性判定信息")
  private Set<String> bindingCharacteristicStrategyCodes;
  
  @ApiModelProperty("该优惠政策模板已绑定的商品选择方式（该值和是否支持商品选择，存在因果关系）")
  private Set<String> bindingProductSelectionMethods;
  
  @ApiModelProperty("该优惠政策已经绑定的可使用的限量执行规则，对应SalePolicyLimitStrategy接口getLimitStrategyCode()方法返回的具体值")
  private Set<String> bindingLimitStrategyCodes;
  
  @ApiModelProperty("该优惠政策已经绑定的可使用的客户选择方式规则，对应SalePolicyCustomerScopeStrategy接口getScopeType()方法返回的具体值")
  private Set<String> bindingScopeTypes;
  
  @ApiModelProperty("该优惠政策已经绑定的可使用的执行政策信息，和执行政策信息支持的阶梯策略")
  private Set<SalePolicyTempleteExecuteStrategyVo> bindingExecuteStraties;
}