package com.biz.crm.dms.business.policy.sdk.vo;

import com.bizunited.nebula.common.vo.TenantOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Transient;

import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Map;
import java.util.Set;

/**
 * 促销政策/销售策略 视图层模型，特征如下：</p>
 * 1、为了策略模块的性能，该VO模型的对象基本上是内存存储</p>
 * 2、通过下层业务模块的监听，清理内存，包括商品分类情况的变化、商品品牌情况的变化、客户分类、客户级别、客户区域情况的变化
 * 商品启禁用情况的变化、客户启禁用情况的变化、政策信息本身的情况变化</p>
 * 3、由于优惠政策的基础底座只负责优惠政策基本信息的记录，所以所有扩展信息都有对应的扩展抽象VO
 * 
 * @author yinwenjie
 */
@Getter
@Setter
public class SalePolicyVo extends TenantOpVo {
  private static final long serialVersionUID = -4092545401943050193L;
  /**
   * 该值没有任何业务含义，只是表达当VO对象存在于缓存中时
   * 这条缓存所代表的优惠政策信息是否已经失效
   */
  @Transient
  @ApiModelProperty("表达当VO对象存在于缓存中时，这条缓存所代表的优惠政策信息是否已经失效")
  private boolean cacheInvalid = false;
  /**
   * 营销活动创建的预授权标记
   */
  @Transient
  @ApiModelProperty("营销活动创建的预授权标记")
  private String prefix;
  /**
   * 营销活动实时状态：1：已完成；2：已失效；3：进行中；4：未开始
   */
  @ApiModelProperty("营销活动实时状态：1：已完成；2：已失效；3：进行中；4：未开始")
  private Integer validType;
  /**
   * 关键的优惠政策类型，匹配不同的 SalePolicyTempleteRegister 接口实现中getType()方法返回的值
   * {@link com.biz.crm.dms.business.policy.sdk.register.SalePolicyTempleteRegister}
   */
  @ApiModelProperty("关键的优惠政策类型，匹配不同的SalePolicyRegister接口实现中getType()方法返回的值")
  private String type;
  /**
   * 优惠政策使用的促销模板编码，必须有，并且促销模板的type必须和该优惠政策的type一致
   */
  @ApiModelProperty("优惠政策使用的促销模板编码，必须有，并且促销模板的type必须和该优惠政策的type一致")
  private String templeteCode;
  /**
   * 优惠政策使用的促销模板名称：注意，这个属性只用于查询时的展示，当使用该VO完成添加/修改等写性质的操作时，该属性不用传入
   */
  @ApiModelProperty("优惠政策使用的促销模板编码，必须有，并且促销模板的type必须和该优惠政策的type一致")
  private String templeteName;
  /**
   * 模板注册类型。注意，这个属性只用于查询时的展示，当使用该VO完成添加/修改等写性质的操作时，该属性不用传入
   */
  @ApiModelProperty("模板注册类型。注意，这个属性只用于查询时的展示，当使用该VO完成添加/修改等写性质的操作时，该属性不用传入")
  private String templeteRegisterType;
  /**
   * 模板注册类型名。注意：这个属性只用于查询时的展示，当使用该VO完成添加/修改等写性质的操作时，该属性不用传入
   */
  @ApiModelProperty("模板注册类型名。注意：这个属性只用于查询时的展示，当使用该VO完成添加/修改等写性质的操作时，该属性不用传入")
  private String templeteRegisterTypeDesc;
  /**
   * 促销编码（必须输入，保证全系统唯一）
   */
  @ApiModelProperty("促销编码")
  private String salePolicyCode;
  /**
   * 促销名称
   */
  @ApiModelProperty("促销名称")
  private String salePolicyName;
  /**
   * 可能的有效期起（包括）
   */
  @ApiModelProperty("可能的有效期起（包括）")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date validStartTime;
  /**
   * 可能的有效期止（包括）
   */
  @ApiModelProperty("可能的有效期止（包括）")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date validEndTime;
  /**
   * 优惠政策中文描述信息（允许最大200字）
   */
  @ApiModelProperty("优惠政策中文描述信息（允许最大200字）")
  private String description;
  /**
   * 是否有效（ture有效，其他值无效）
   */
  @ApiModelProperty("是否有效（ture有效，其他值无效）")
  private Boolean effective;
  /**
   * 是否参与同一商品的政策叠加（默认为false）
   */
  @ApiModelProperty("是否参与同一商品的政策叠加（默认为false）")
  private Boolean overlap = false;
  /**
   * 整单优惠还是商品优惠：true：整单优惠；false：商品优惠</br>
   * 该属性也不是创建或修改时传入的，而是通过优惠政策匹配的注册机中的supportProduct返回值决定的
   */
  @ApiModelProperty("整单优惠还是商品优惠：true：整单优惠；false：商品优惠")
  private Boolean wholePolicy = false;
  /**
   * 由前端页面使用的 本品-优惠规格 信息，对于业务逻辑来说无意义，也不是必须传入的
   */
  @ApiModelProperty("由前端页面使用的 本品-优惠规格 信息，对于业务逻辑来说无意义，也不是必须传入的")
  private String promotionalGoods;
  /**
   * 显示信息
   */
  @ApiModelProperty("显示信息")
  private String label;
  
  // ============================== 以下信息是优惠政策信息中抽象的特性执行规则信息
  @ApiModelProperty("优惠政策信息中抽象的特性执行规则信息，注意：可能没有值")
  private Set<AbstractCharacteristicInfo> characteristicInfos;
  
  // ============================== 以下信息是抽象的商品优惠中的商品信息
  /**
   * 注意，只有当wholePolicy为false的情况下，该部分信息才起作用
   */
  @ApiModelProperty("注意，只有当wholePolicy为false的情况下，该部分信息才起作用")
  private Set<AbstractSalePolicyProductInfo> salePolicyProductInfos;
  
  // ============================== 以下信息是抽象的优惠政策中的优惠门槛信息
  @ApiModelProperty("抽象优惠政策中的优惠门槛信息部分")
  private AbstractSalePolicyThreshold salePolicyProductThreshold;
  
  //============================== 以下对应了 优惠政策中促销规则 部分的信息
  @ApiModelProperty("抽象的优惠政策执行信息部分")
  private Set<AbstractSalePolicyExecutorInfo> salePolicyExecutorInfos;
  
  //============================== 以下对应了 优惠政策中促销规则 部分的信息
  /**
   * 抽象的已被绑定的限量控制信息
   */
  @ApiModelProperty("抽象的已被绑定的限量控制信息")
  @Transient
  private Set<AbstractSalePolicyLimitInfo> salePolicyLimitInfos;
  
  //============================== 以下对应了 优惠政策可能存在的预算 部分的信息
  
  // TODO 后续再来设计
  
  //============================== 以下对应了 优惠政策适用的范围范围 部分的信息
  /**
   * 根据具体的客户返回圈定策略，确定的可以使用该优惠政策的业务范围编号；
   * Key：从某个具体的SalePolicyCustomerScopeStrategy中返回得到的copeType信息
   * Value：这个客户选择维度的业务范围：例如组织机构Code
   */
  @Transient
  @ApiModelProperty("根据具体的客户返回圈定策略，最终确定的可以使用该优惠政策的客户业务编号信息（创建或者修改时，都无需传入该属性）")
  private Map<String , Set<? extends AbstractSalePolicyCustomerScopeInfo>> customerScopeMapping;
}