/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.standard.discount.executestrategy;

import com.biz.crm.dms.business.policy.local.context.DefaultCycleExecuteContext;
import com.biz.crm.dms.business.policy.local.cyclestrategy.AccumulationCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.MultipleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.SingleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutor;
import com.biz.crm.dms.business.policy.local.executestrategy.AbstractStandardExecuteStrategy;
import com.biz.crm.dms.business.policy.local.sharestrategy.SubtotalShareStrategyWithAmountAndNumber;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorLadderVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.CycleStepResult;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCycleRuleStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteShareStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public abstract class AbstractPriceDiscountSectionExecuteStrategy
extends AbstractStandardExecuteStrategy
implements SalePolicyExecuteStrategy<SalePolicyExecutorVo> {
    public Class<SalePolicyExecutorVo> getSalePolicyExecutorInfoClass() {
        return SalePolicyExecutorVo.class;
    }

    public Class<? extends SalePolicyExecuteShareStrategy> getSalePolicyExecuteShareStrategy() {
        return SubtotalShareStrategyWithAmountAndNumber.class;
    }

    public Collection<Class<? extends SalePolicyCycleRuleStrategy>> getCycleRuleStrategyClasses() {
        return Lists.newArrayList((Object[])new Class[]{SingleCycleRuleStrategy.class, MultipleCycleRuleStrategy.class, AccumulationCycleRuleStrategy.class});
    }

    public List<SalePolicyExecutorVo> onRequestSalePolicyExecutorInfo(String tenantCode, String salePolicyCode) {
        List salePolicyExecutors = this.salePolicyExecutorService.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode, this.getExecuteStrategyCode());
        if (CollectionUtils.isEmpty((Collection)salePolicyExecutors)) {
            return null;
        }
        Collection salePolicyExecutorVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)salePolicyExecutors, SalePolicyExecutor.class, SalePolicyExecutorVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"salePolicyExecutorLadders", "salePolicyExecutorLadders.executorLadderVars"});
        return Lists.newArrayList((Iterable)salePolicyExecutorVos);
    }

    public void onSaveSalePolicyExecutorInfo(boolean update, SalePolicyVo currentSalePolicy, SalePolicyVo oldSalePolicy) {
        this.handleSaveSalePolicyExecutorInfo(update, currentSalePolicy, oldSalePolicy, currentSalePolicy.getSalePolicyExecutorInfos().stream().map(item -> (SalePolicyExecutorVo)item).collect(Collectors.toSet()));
        super.validatetExpressionParams(currentSalePolicy);
    }

    public AbstractCycleExecuteContext buildCycleExecuteContext(AbstractPolicyExecuteContext executeContext, String executorCode, Set<SalePolicyConProduct> initPolicyProducts, String customerCode) {
        return super.buildDefaultCycleExecuteContext(executorCode, executeContext, initPolicyProducts, customerCode);
    }

    protected boolean execute(AbstractCycleExecuteContext abstractCycleExecuteContext, int index, int times, Map<String, Object> varParams, SalePolicyExecutorLadderVo salePolicyExecutorLadder) {
        DefaultCycleExecuteContext cycleExecuteContext = (DefaultCycleExecuteContext)abstractCycleExecuteContext;
        CycleStepResult lastCycleStepResult = cycleExecuteContext.findLastStepResult();
        BigDecimal lastSurplusSubtotalAmount = lastCycleStepResult.getLastSurplusSubtotalAmount();
        Object fullPriceValueObject = varParams.get("fullPriceValue");
        Object discountValueObject = varParams.get("discountValue");
        if (fullPriceValueObject == null || discountValueObject == null) {
            return false;
        }
        Integer fullPriceValue = (Integer)fullPriceValueObject;
        BigDecimal discountValue = (BigDecimal)discountValueObject;
        if (fullPriceValue <= 0 || discountValue.compareTo(BigDecimal.ZERO) <= 0) {
            return false;
        }
        if ((float)fullPriceValue.intValue() > lastSurplusSubtotalAmount.floatValue()) {
            return false;
        }
        BigDecimal lastSubtotalAmount = lastCycleStepResult.getLastSubtotalAmount();
        Integer lastSurplusSubtotalNumber = lastCycleStepResult.getLastSurplusSubtotalNumber();
        CycleStepResult newCycleStepResult = new CycleStepResult(index, times, lastSubtotalAmount, lastSurplusSubtotalAmount, lastSurplusSubtotalNumber);
        BigDecimal result = new BigDecimal(fullPriceValue).multiply(BigDecimal.ONE.subtract(discountValue.divide(new BigDecimal(10))));
        newCycleStepResult.setLastSubtotalAmount(lastSubtotalAmount.subtract(result));
        newCycleStepResult.setLastSurplusSubtotalAmount(lastSurplusSubtotalAmount.subtract(new BigDecimal(fullPriceValue)));
        newCycleStepResult.setLastSurplusSubtotalNumber(lastSurplusSubtotalNumber);
        cycleExecuteContext.addStepResult(newCycleStepResult);
        return true;
    }
}

