package com.biz.crm.dms.business.policy.standard.discount.config;

import com.biz.crm.dms.business.policy.local.characteristic.NotStackingCharacteristicStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.ChannelForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.DistributorForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.OrgForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.characteristic.CharacteristicStrategy;
import com.biz.crm.dms.business.policy.sdk.enums.ProductSelectionMethod;
import com.biz.crm.dms.business.policy.sdk.register.SalePolicyTempleteRegister;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyStickupListener;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractCharacteristicInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyLimitInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyProductInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyThreshold;
import com.biz.crm.dms.business.policy.standard.discount.executestrategy.ProductCountDiscountExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.discount.executestrategy.ProductPriceDiscountExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.discount.executestrategy.ProductPriceDiscountSectionExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.discount.limitstrategy.StandardDiscountCustomerAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.discount.limitstrategy.StandardDiscountCustomerBillAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.discount.limitstrategy.StandardDiscountCustomerBillQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.discount.limitstrategy.StandardDiscountCustomerQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.discount.limitstrategy.StandardDiscountTotalAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.discount.limitstrategy.StandardDiscountTotalQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.discount.notifier.StandardDiscountForStickupListener;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collection;

/**
 * DMS标品中商品打折优惠政策模板的定义
 * @author yinwenjie 
 */
public class StandardDiscountTempleteRegister implements SalePolicyTempleteRegister {
  /**
   * 负责商品打折优惠信息运维工作的维护监听器
   */
  @Autowired(required = false)
  private StandardDiscountForStickupListener standardDiscountForStickupListener;
  @Override
  public String getType() {
    // 商品打折
    return "standard_discount_supportproduct";
  }

  @Override
  public String getTypeDesc() {
    return "商品-打折";
  }

  @Override
  public Boolean supportProduct() {
    return true;
  }
  
  @Override
  public ProductSelectionMethod[] getProductSelectionMethods() {
    // 支持多本品同一规则和多本品不同规则
    return new ProductSelectionMethod[] {ProductSelectionMethod.MULTIPLE , ProductSelectionMethod.SINGLE};
  }

  @Override
  public SalePolicyStickupListener<? extends AbstractSalePolicyThreshold, ? extends AbstractSalePolicyProductInfo> getStickupListener() {
    return this.standardDiscountForStickupListener;
  }
  
  @SuppressWarnings("unchecked")
  @Override
  public Collection<Class<? extends SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>>> getCustomerScopeStrategyClasses() {
    // 标品的商品打折三种客户范围选择方式都支持
    return Sets.newHashSet(DistributorForSalePolicyCustomerScopeStrategy.class , ChannelForSalePolicyCustomerScopeStrategy.class , OrgForSalePolicyCustomerScopeStrategy.class);
  }
  
  @Override
  public Collection<Class<? extends SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo>>> getBindableLimitStrategyClasses() {
    return Lists.newArrayList(
        StandardDiscountCustomerBillAmountLimitStrategy.class,
        StandardDiscountCustomerAmountLimitStrategy.class,
        StandardDiscountTotalAmountLimitStrategy.class,
        StandardDiscountCustomerBillQuantityLimitStrategy.class,
        StandardDiscountCustomerQuantityLimitStrategy.class,
        StandardDiscountTotalQuantityLimitStrategy.class
    );
  }
  
  @Override
  public Collection<Class<? extends SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo>>> getExecuteStrategyClasses() {
    // 商品打折优惠，有三个优惠执行策略可以使用，满数量享打折、满金额享打折、满金额（区间）打折
    return Lists.newArrayList(ProductCountDiscountExecuteStrategy.class , ProductPriceDiscountExecuteStrategy.class , ProductPriceDiscountSectionExecuteStrategy.class);
  }

  @Override
  public Collection<Class<? extends CharacteristicStrategy<? extends AbstractCharacteristicInfo>>> getCharacteristicStrategyClasses() {
    // 设定执行特性
    return Lists.newArrayList(NotStackingCharacteristicStrategy.class);
  }
}
