package com.biz.crm.dms.business.policy.standard.discount.config;

import com.biz.crm.dms.business.policy.local.characteristic.NotStackingCharacteristicStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.ChannelForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.DistributorForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.local.scopestrategy.OrgForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.characteristic.CharacteristicStrategy;
import com.biz.crm.dms.business.policy.sdk.enums.ProductSelectionMethod;
import com.biz.crm.dms.business.policy.sdk.register.SalePolicyTempleteRegister;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyStickupListener;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractCharacteristicInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyLimitInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyProductInfo;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyThreshold;
import com.biz.crm.dms.business.policy.standard.discount.executestrategy.WholeCountDiscountExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.discount.executestrategy.WholePriceDiscountExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.discount.executestrategy.WholePriceDiscountSectionExecuteStrategy;
import com.biz.crm.dms.business.policy.standard.discount.limitstrategy.StandardDiscountWholeCustomerAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.discount.limitstrategy.StandardDiscountWholeCustomerBillAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.discount.limitstrategy.StandardDiscountWholeCustomerBillQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.discount.limitstrategy.StandardDiscountWholeCustomerQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.discount.limitstrategy.StandardDiscountWholeTotalAmountLimitStrategy;
import com.biz.crm.dms.business.policy.standard.discount.limitstrategy.StandardDiscountWholeTotalQuantityLimitStrategy;
import com.biz.crm.dms.business.policy.standard.discount.notifier.StandardWholeDiscountForStickupListener;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collection;

/**
 * DMS标品中整单打折优惠政策模板的定义
 * @author yinwenjie 
 */
public class StandardDiscountWholeTempleteRegister implements SalePolicyTempleteRegister {
  @Autowired(required = false)
  private StandardWholeDiscountForStickupListener standardWholeDiscountForStickupListener;
  @Override
  public String getType() {
    // 整单打折
    return "standard_discount_unsupportproduct";
  }

  @Override
  public String getTypeDesc() {
    return "整单-打折";
  }

  @Override
  public Boolean supportProduct() {
    return false;
  }
  
  @Override
  public ProductSelectionMethod[] getProductSelectionMethods() {
    // 不支持商品选择方式
    return new ProductSelectionMethod[] {ProductSelectionMethod.NOSELECT};
  }
  
  @Override
  public SalePolicyStickupListener<? extends AbstractSalePolicyThreshold, ? extends AbstractSalePolicyProductInfo> getStickupListener() {
    return standardWholeDiscountForStickupListener;
  }
  
  @SuppressWarnings("unchecked")
  @Override
  public Collection<Class<? extends SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>>> getCustomerScopeStrategyClasses() {
    return Sets.newHashSet(DistributorForSalePolicyCustomerScopeStrategy.class , ChannelForSalePolicyCustomerScopeStrategy.class , OrgForSalePolicyCustomerScopeStrategy.class);
  }
  
  @Override
  public Collection<Class<? extends SalePolicyLimitStrategy<? extends AbstractSalePolicyLimitInfo>>> getBindableLimitStrategyClasses() {
    return Lists.newArrayList(
        StandardDiscountWholeCustomerBillAmountLimitStrategy.class,
        StandardDiscountWholeCustomerAmountLimitStrategy.class,
        StandardDiscountWholeTotalAmountLimitStrategy.class,
        StandardDiscountWholeCustomerBillQuantityLimitStrategy.class,
        StandardDiscountWholeCustomerQuantityLimitStrategy.class,
        StandardDiscountWholeTotalQuantityLimitStrategy.class
    );
  } 
  
  @Override
  public Collection<Class<? extends SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo>>> getExecuteStrategyClasses() {
    // 整单打折优惠，有三个优惠执行策略可以使用：满数量享打折、满金额享打折、满金额区间打折
    return Lists.newArrayList(WholeCountDiscountExecuteStrategy.class , WholePriceDiscountExecuteStrategy.class , WholePriceDiscountSectionExecuteStrategy.class);
  } 
  
  @Override
  public Collection<Class<? extends CharacteristicStrategy<? extends AbstractCharacteristicInfo>>> getCharacteristicStrategyClasses() {
    // 设定执行特性
    return Lists.newArrayList(NotStackingCharacteristicStrategy.class);
  }
}
