package com.biz.crm.dms.business.policy.standard.discount.executestrategy;

import com.biz.crm.dms.business.policy.local.cyclestrategy.AccumulationCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.MultipleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.SingleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutor;
import com.biz.crm.dms.business.policy.local.executestrategy.AbstractStandardExecuteStrategy;
import com.biz.crm.dms.business.policy.local.sharestrategy.SubtotalShareStrategyWithAmountAndNumber;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorLadderVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.local.context.DefaultCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.CycleStepResult;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCycleRuleStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteShareStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.google.common.collect.Lists;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.springframework.util.CollectionUtils;

/**
 * 用于管理标品中各种“满数量折扣”逻辑的业务代码
 * @author yinwenjie
 */
public abstract class AbstractCountDiscountExecuteStrategy extends AbstractStandardExecuteStrategy implements SalePolicyExecuteStrategy<SalePolicyExecutorVo> {
  
  @Override
  public Class<SalePolicyExecutorVo> getSalePolicyExecutorInfoClass() {
    return SalePolicyExecutorVo.class;
  }

  @Override
  public Class<? extends SalePolicyExecuteShareStrategy> getSalePolicyExecuteShareStrategy() {
    return SubtotalShareStrategyWithAmountAndNumber.class;
  }
  
  @Override
  public Collection<Class<? extends SalePolicyCycleRuleStrategy>> getCycleRuleStrategyClasses() {
    return Lists.newArrayList(SingleCycleRuleStrategy.class, MultipleCycleRuleStrategy.class , AccumulationCycleRuleStrategy.class);
  }
  
  @Override
  public List<SalePolicyExecutorVo> onRequestSalePolicyExecutorInfo(String tenantCode, String salePolicyCode) {
    List<SalePolicyExecutor> salePolicyExecutors = super.salePolicyExecutorService.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode , getExecuteStrategyCode());
    if(CollectionUtils.isEmpty(salePolicyExecutors)) {
      return null;
    }
    // 转换成特定的VO（集合）
    Collection<SalePolicyExecutorVo> salePolicyExecutorVos = super.nebulaToolkitService.copyCollectionByWhiteList(salePolicyExecutors, SalePolicyExecutor.class, SalePolicyExecutorVo.class, LinkedHashSet.class, ArrayList.class, "salePolicyExecutorLadders" , "salePolicyExecutorLadders.executorLadderVars");
    return Lists.newArrayList(salePolicyExecutorVos);
  }

  @Override
  public void onSaveSalePolicyExecutorInfo(boolean update, SalePolicyVo currentSalePolicy, SalePolicyVo oldSalePolicy) {
    this.handleSaveSalePolicyExecutorInfo(update, currentSalePolicy, oldSalePolicy, currentSalePolicy.getSalePolicyExecutorInfos().stream().map(item -> (SalePolicyExecutorVo)item).collect(Collectors.toSet()));
    super.validatetExpressionParams(currentSalePolicy);
  }
  
  public AbstractCycleExecuteContext buildCycleExecuteContext(AbstractPolicyExecuteContext executeContext, String executorCode , Set<SalePolicyConProduct> initPolicyProducts , String customerCode) {
    return super.buildDefaultCycleExecuteContext(executorCode , executeContext, initPolicyProducts, customerCode);
  }
  
  protected boolean execute(AbstractCycleExecuteContext abstractCycleExecuteContext , int index, int times , Map<String, Object> varParams , SalePolicyExecutorLadderVo salePolicyExecutorLadder) {
    DefaultCycleExecuteContext cycleExecuteContext = (DefaultCycleExecuteContext)abstractCycleExecuteContext;
    CycleStepResult lastCycleStepResult = cycleExecuteContext.findLastStepResult();
    // 该变量是指，截止上次优惠后，还有多少本品小计数量没有参加优惠
    Integer lastSurplusSubtotalNumber = lastCycleStepResult.getLastSurplusSubtotalNumber();
    // 这里一定是有值的
    Object fullCountValueObject = varParams.get("fullCountValue");
    Object discountValueObject = varParams.get("discountValue");
    if(fullCountValueObject == null || discountValueObject == null) {
      return false;
    }
    Integer fullCountValue = (Integer)fullCountValueObject;
    BigDecimal discountValue = (BigDecimal)discountValueObject;
    // 不允许0满减的极端情况出现
    if(fullCountValue <= 0 || discountValue.compareTo(BigDecimal.ZERO) <= 0) {
      return false;
    }
    // 如果条件成立，说明不满足优惠条件
    if(fullCountValue > lastSurplusSubtotalNumber) {
      return false;
    }
    
    // ======== 如果处理逻辑走到了这里，说明符合该阶梯的处理前提，开始正式进行优惠处理
    BigDecimal lastSubtotalAmount = lastCycleStepResult.getLastSubtotalAmount();
    BigDecimal lastSurplusSubtotalAmount = lastCycleStepResult.getLastSurplusSubtotalAmount();
    CycleStepResult newCycleStepResult = new CycleStepResult(index, times, lastSubtotalAmount, lastSurplusSubtotalAmount, lastSurplusSubtotalNumber);
    // 计算折扣 还没有参与优惠的金额 * 折扣数量
    BigDecimal result = lastSubtotalAmount.multiply(discountValue.divide(new BigDecimal(10))); 
    newCycleStepResult.setLastSubtotalAmount(result);
    // 注意，满数量总价折扣和满数量区间折扣实际上业务逻辑是重复的，所以只需要一个计算策略即可
    newCycleStepResult.setLastSurplusSubtotalAmount(lastSurplusSubtotalAmount);
    newCycleStepResult.setLastSurplusSubtotalNumber(lastSurplusSubtotalNumber - fullCountValue);
    cycleExecuteContext.addStepResult(newCycleStepResult);
    return true;
  }
}
