package com.biz.crm.dms.business.policy.standard.discount.executestrategy;

import com.biz.crm.dms.business.policy.local.cyclestrategy.AccumulationCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.MultipleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.SingleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;

import org.apache.commons.lang3.StringUtils;

/**
 * 在商品打折优惠方式中使用的，满数量享打折的具体优惠执行策略
 * @author yinwenjie
 */
public class ProductCountDiscountExecuteStrategy extends AbstractCountDiscountExecuteStrategy implements SalePolicyExecuteStrategy<SalePolicyExecutorVo> {
  
  @Override 
  public String getExecuteStrategyCode() {
    return "productCountDiscountExecuteStrategy";
  }

  @Override
  public String getExecuteStrategyDesc() {
    return "满数量享打折";
  }

  @Override
  public String getExpression() {
    return "本单中本品数量购买满{integer:input-integer:fullCountValue}销售单位，本品打{bigdecimal:input-random:discountValue}折";
  }

  public String getCycleRuleExample(String cycleRuleCode) {
    if(StringUtils.equals(cycleRuleCode, SingleCycleRuleStrategy.SINGLE)) {
      return "例如：满1000销售单位打7折，满500销售单位打9折。那么本品销售数量为2500单位，销售金额为5000，则打折5000*0.7 = 3500";
    } else if(StringUtils.equals(cycleRuleCode, MultipleCycleRuleStrategy.MULTIPLE)) { 
      return "例如：满1000销售单位打7折，满500销售单位打9折。那么本品销售数量为2500单位，销售金额为5000，则打折5000*0.7*0.9 = 3150";
    } else if(StringUtils.equals(cycleRuleCode, AccumulationCycleRuleStrategy.ACCUMULATION)) { 
      return "例如：满1000销售单位打7折，满500销售单位打9折。那么本品销售数量为2500单位，销售金额为5000，则打折5000*0.7*0.7*0.9 = 2205";
    }
    
    return "";
  }
}