package com.biz.crm.dms.business.policy.standard.discount.executestrategy;

import com.biz.crm.dms.business.policy.local.cyclestrategy.AccumulationCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.MultipleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.SingleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;

import org.apache.commons.lang3.StringUtils;

/**
 * 在商品打折优惠方式中使用的，满金额（区间）享打折的具体优惠执行策略
 * @author yinwenjie
 */
public class ProductPriceDiscountSectionExecuteStrategy extends AbstractPriceDiscountSectionExecuteStrategy implements SalePolicyExecuteStrategy<SalePolicyExecutorVo> {
  
  @Override
  public String getExecuteStrategyCode() {
    return "productPriceDiscountSectionExecuteStrategy";
  }

  @Override
  public String getExecuteStrategyDesc() {
    return "满金额享（区间）打折";
  }

  @Override
  public String getExpression() {
    return "本单中本品数量购买满{integer:input-integer:fullPriceValue}元，优惠区间打{bigdecimal:input-random:discountValue}折";
  }
  
  public String getCycleRuleExample(String cycleRuleCode) {
    // 写死即可
    if(StringUtils.equals(cycleRuleCode, SingleCycleRuleStrategy.SINGLE)) {
      return "例如：满1000元打7折，满500元打9折。那么本品销售金额为5000，则打折5000 - (1000 * 0.3) = 4700";
    } else if(StringUtils.equals(cycleRuleCode, MultipleCycleRuleStrategy.MULTIPLE)) { 
      return "例如：满1000元打7折，满500元打9折。那么本品销售金额为5000，则打折5000 - (1000 * 0.3) - (500 * 0.1) = 4650";
    } else if(StringUtils.equals(cycleRuleCode, AccumulationCycleRuleStrategy.ACCUMULATION)) { 
      return "例如：满1000元打7折，满500元打9折。那么本品销售金额为5300，则打折5300 - (1000 * 0.3) * 5 -  = 3800";
    } 
    
    return "";
  }
}
