package com.biz.crm.dms.business.policy.standard.discount.executestrategy;

import com.biz.crm.dms.business.policy.local.cyclestrategy.AccumulationCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.MultipleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.SingleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;

import org.apache.commons.lang3.StringUtils;

/**
 * 在整单打折优惠方式中使用的，满数量享打折的具体优惠执行策略</br>
 * 注意：“整单满数量享打折”和“商品满数量享打折”ProductCountDiscountExecuteStrategy，除了描述信息不一样以外、从调用方接收的本品规模不一样，
 * 处理逻辑完全一样。所以可以直接集成AbstractCountDiscountExecuteStrategy即可
 * @author yinwenjie
 */
public class WholeCountDiscountExecuteStrategy extends AbstractCountDiscountExecuteStrategy implements SalePolicyExecuteStrategy<SalePolicyExecutorVo> {

  @Override
  public String getExecuteStrategyCode() {
    return "wholeCountDiscountExecuteStrategy";
  }

  @Override
  public String getExecuteStrategyDesc() {
    return "整单满数量享打折";
  }

  @Override
  public String getExpression() {
    return "整单本品数量购买满{integer:input-integer:fullCountValue}销售单位，整单打{decimal:input-random:discountValue}折";
  }
  
  @Override
  public String getCycleRuleExample(String cycleRuleCode) {
    if(StringUtils.equals(cycleRuleCode, SingleCycleRuleStrategy.SINGLE)) {
      return "例如：满1000销售单位打7折，满500销售单位打9折。那么整单销售数量为2500单位，销售金额为5000，则打折5000*0.7 = 3500";
    } else if(StringUtils.equals(cycleRuleCode, MultipleCycleRuleStrategy.MULTIPLE)) { 
      return "例如：满1000销售单位打7折，满500销售单位打9折。那么整单销售数量为2500单位，销售金额为5000，则打折5000*0.7*0.9 = 3150";
    } else if(StringUtils.equals(cycleRuleCode, AccumulationCycleRuleStrategy.ACCUMULATION)) { 
      return "例如：满1000销售单位打7折，满500销售单位打9折。那么整单销售数量为2500单位，销售金额为5000，则打折5000*0.7*0.7*0.9 = 2205";
    }
    return "";
  }
}
