package com.biz.crm.dms.business.policy.standard.discount.executestrategy;

import com.biz.crm.dms.business.policy.local.cyclestrategy.AccumulationCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.MultipleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.SingleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;

import org.apache.commons.lang3.StringUtils;

/**
 * 在整单打折优惠方式中使用的，满金额享（区间）打折的具体优惠执行策略</br>
 * 注意：“整单满金额享（区间）打折”和“本品满金额享（区间）打折”ProductPriceDiscountSectionExecuteStrategy，除了描述信息不一样以外、从调用方接收的本品规模不一样，
 * 处理逻辑完全一样。所以可以直接集成AbstractPriceDiscountSectionExecuteStrategy即可
 * @author yinwenjie
 */
public class WholePriceDiscountSectionExecuteStrategy extends AbstractPriceDiscountSectionExecuteStrategy implements SalePolicyExecuteStrategy<SalePolicyExecutorVo> {
  
  @Override
  public String getExecuteStrategyCode() {
    return "wholePriceDiscountSectionExecuteStrategy";
  }

  @Override
  public String getExecuteStrategyDesc() {
    return "整单满金额享（区间）打折";
  }

  @Override
  public String getExpression() {
    return "整单本品金额购买满{decimal:input-integer:fullPriceValue}元，优惠区间打{bigdecimal:input-random:discountValue}折";
  }

  @Override
  public String getCycleRuleExample(String cycleRuleCode) {
    if(StringUtils.equals(cycleRuleCode, SingleCycleRuleStrategy.SINGLE)) {
      return "例如：满1000元打7折，满500元打9折。那么整单销售金额为5000，则打折5000 - (1000 * 0.3) = 4700";
    } else if(StringUtils.equals(cycleRuleCode, MultipleCycleRuleStrategy.MULTIPLE)) { 
      return "例如：满1000元打7折，满500元打9折。那么整单销售金额为5000，则打折5000 - (1000 * 0.3) - (500 * 0.1) = 4650";
    } else if(StringUtils.equals(cycleRuleCode, AccumulationCycleRuleStrategy.ACCUMULATION)) { 
      return "例如：满1000元打7折，满500元打9折。那么整单销售金额为5300，则打折5300 - (1000 * 0.3) * 5 -  = 3800";
    } 
    
    return "";
  }
}
