package com.biz.crm.dms.business.policy.standard.discount.notifier;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyThreshold;
import com.biz.crm.dms.business.policy.local.notifier.AbstractSalePolicyStickupListener;
import com.biz.crm.dms.business.policy.local.service.SalePolicyThresholdService;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyProductVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyThresholdDetailVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyThresholdProductVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyThresholdVo;

import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyStickupListener;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyThreshold;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 整单打折优惠的商品门槛和商品明细数据运维监听器
 * @author yinwenjie
 */
@Component
public class StandardWholeDiscountForStickupListener extends AbstractSalePolicyStickupListener implements SalePolicyStickupListener<SalePolicyThresholdVo, SalePolicyProductVo>  {
  @Autowired(required = false)
  private SalePolicyThresholdService salePolicyThresholdService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  
  // ======= 以下是优惠政策关联的优惠门槛信息
  
  @Override
  public Class<SalePolicyThresholdVo> getSalePolicyProductThresholdClass() {
    return SalePolicyThresholdVo.class;
  }

  @Override
  public SalePolicyThresholdVo onRequestSalePolicyThreshold(String tenantCode , String salePolicyCode) {
    SalePolicyThreshold salePolicyThreshold = this.salePolicyThresholdService.findBySalePolicyCode(salePolicyCode, tenantCode);
    if(salePolicyThreshold == null) {
      return null;
    }
    // 转换成确定的VO后进行返回 
    SalePolicyThresholdVo salePolicyThresholdVo = this.nebulaToolkitService.copyObjectByWhiteList(salePolicyThreshold, SalePolicyThresholdVo.class , LinkedHashSet.class, ArrayList.class, "thresholdProducts");
    // 完善得到的vo的信息
    List<SalePolicyThresholdDetailVo> thresholdDetails = salePolicyThresholdVo.getThresholdDetails();
    if(!CollectionUtils.isEmpty(thresholdDetails)) {
      for (SalePolicyThresholdDetailVo thresholdDetail : thresholdDetails) {
        thresholdDetail.setSalePolicyCode(salePolicyCode);
        thresholdDetail.setTenantCode(tenantCode);
        List<SalePolicyThresholdProductVo> thresholdProducts = thresholdDetail.getThresholdProducts();
        if(!CollectionUtils.isEmpty(thresholdProducts)) {
          for (SalePolicyThresholdProductVo thresholdProduct : thresholdProducts) {
            thresholdProduct.setTenantCode(tenantCode);
            thresholdProduct.setSalePolicyCode(salePolicyCode);
            thresholdProduct.setThresholdDetailCode(thresholdDetail.getThresholdDetailCode());
          }
        }
      }
    }
    return salePolicyThresholdVo;
  }

  @Override
  public void onSaveSalePolicyProductThreshold(boolean update , SalePolicyVo currentSalePolicy , SalePolicyVo oldSalePolicy, SalePolicyThresholdVo salePolicyThreshold) {
    super.onSaveSalePolicyProductThreshold(update, currentSalePolicy, oldSalePolicy, salePolicyThreshold);
  }
  
  @Override
  public Pair<Map<String,Set<String>>,String> executeThreshold(Set<SalePolicyConProduct> policyConProducts, AbstractPolicyExecuteContext abstractPolicyExecuteContext, AbstractSalePolicyThreshold abstractSalePolicyThreshold) {
    return super.executeThreshold(policyConProducts, abstractPolicyExecuteContext, abstractSalePolicyThreshold);
  }
  
  // ======= 以下是优惠政策关联的优惠本品信息

  @Override
  public Class<SalePolicyProductVo> getSalePolicyProductInfoClass() {
    // 由于是整单优惠，所以不涉及对应的优惠商品模型描述
    return SalePolicyProductVo.class;
  }

  @Override
  @Transactional
  public void onSaveSalePolicyProductInfo(boolean update , SalePolicyVo currentSalePolicyVo, SalePolicyVo oldSalePolicy , Set<SalePolicyProductVo> salePolicyProductInfos) {
    // 由于是整单优惠，所以无需进行优惠商品明细信息的保存
  }
  
  @Override
  public List<SalePolicyProductVo> onRequestSalePolicyProductInfos(String tenantCode , String salePolicyCode) {
    // 由于是整单优惠，所以无需对优惠商品明细的查询事件进行响应
    return null;
  }
}
