package com.biz.crm.dms.business.policy.standard.fullminus.executestrategy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import javax.transaction.Transactional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import com.biz.crm.dms.business.policy.sdk.context.CycleStepResult;
import com.biz.crm.dms.business.policy.local.context.DefaultCycleExecuteContext;
import com.biz.crm.dms.business.policy.local.cyclestrategy.AccumulationCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.MultipleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.SingleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutor;
import com.biz.crm.dms.business.policy.local.executestrategy.AbstractStandardExecuteStrategy;
import com.biz.crm.dms.business.policy.local.service.SalePolicyExecutorService;
import com.biz.crm.dms.business.policy.local.sharestrategy.SubtotalShareStrategyWithAmountAndNumber;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorLadderVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;

import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCycleRuleStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteShareStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;

/**
 * 该抽象类用于管理标品中各种，“满数量享总价满减”的核心业务逻辑
 * @author yinwenjie
 */
public abstract class AbstractFullminusSubtotalCountExecuteStrategy extends AbstractStandardExecuteStrategy implements SalePolicyExecuteStrategy<SalePolicyExecutorVo> {

  @Autowired(required = false)
  private SalePolicyExecutorService salePolicyExecutorService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  
  @Override
  public Class<SalePolicyExecutorVo> getSalePolicyExecutorInfoClass() {
    return SalePolicyExecutorVo.class;
  }
  
  @Override
  public Class<? extends SalePolicyExecuteShareStrategy> getSalePolicyExecuteShareStrategy() {
    // 优惠后，应该按照小计数量进行优惠结果分摊——分摊到参加优惠的商品明细上
    return SubtotalShareStrategyWithAmountAndNumber.class;
  }
  
  @Override
  public Collection<Class<? extends SalePolicyCycleRuleStrategy>> getCycleRuleStrategyClasses() {
    // 标品中的三种阶梯循环方式，都支持
    return Lists.newArrayList(SingleCycleRuleStrategy.class , MultipleCycleRuleStrategy.class , AccumulationCycleRuleStrategy.class);
  }
  
  @Override
  public List<SalePolicyExecutorVo> onRequestSalePolicyExecutorInfo(String tenantCode , String salePolicyCode) {
    List<SalePolicyExecutor> salePolicyExecutors = this.salePolicyExecutorService.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode , getExecuteStrategyCode());
    if(CollectionUtils.isEmpty(salePolicyExecutors)) {
      return null;
    }
    // 转换成特定的VO（集合）
    Collection<SalePolicyExecutorVo> salePolicyExecutorVos = this.nebulaToolkitService.copyCollectionByWhiteList(salePolicyExecutors, SalePolicyExecutor.class, SalePolicyExecutorVo.class, LinkedHashSet.class, ArrayList.class, "salePolicyExecutorLadders" , "salePolicyExecutorLadders.executorLadderVars");
    return Lists.newArrayList(salePolicyExecutorVos);
  }

  @Override
  @Transactional
  public void onSaveSalePolicyExecutorInfo(boolean update , SalePolicyVo currentSalePolicy , SalePolicyVo oldSalePolicy) {
    this.handleSaveSalePolicyExecutorInfo(update, currentSalePolicy, oldSalePolicy, currentSalePolicy.getSalePolicyExecutorInfos().stream().map(item -> (SalePolicyExecutorVo)item).collect(Collectors.toSet()));
    super.validatetExpressionParams(currentSalePolicy);
  }
  
  public AbstractCycleExecuteContext buildCycleExecuteContext(AbstractPolicyExecuteContext executeContext , String executorCode , Set<SalePolicyConProduct> initPolicyProducts , String customerCode) {
    return super.buildDefaultCycleExecuteContext(executorCode , executeContext, initPolicyProducts, customerCode);
  }
  
  protected boolean execute(AbstractCycleExecuteContext abstractCycleExecuteContext , int index, int times , Map<String, Object> varParams, SalePolicyExecutorLadderVo salePolicyExecutorLadder) {
    DefaultCycleExecuteContext cycleExecuteContext = (DefaultCycleExecuteContext)abstractCycleExecuteContext;
    CycleStepResult lastCycleStepResult = cycleExecuteContext.findLastStepResult();
    // 该变量是指，截止上次优惠后，还有多少本品小计数量没有参加优惠
    Integer lastSurplusSubtotalNumber = lastCycleStepResult.getLastSurplusSubtotalNumber();
    // 这里一定是有值的
    Object fullCountValueObject = varParams.get("fullCountValue");
    Object discountValueObject = varParams.get("priceValue");
    if(fullCountValueObject == null || discountValueObject == null) {
      return false;
    }
    Integer fullCountValue = (Integer)fullCountValueObject;
    BigDecimal discountValue = (BigDecimal)discountValueObject;
    // 不允许0满减的极端情况出现
    if(fullCountValue <= 0 || discountValue.compareTo(BigDecimal.ZERO) <= 0) {
      return false;
    }
    // 如果条件成立，说明不满足优惠条件
    if(fullCountValue > lastSurplusSubtotalNumber) {
      return false;
    }
    
    // ======== 如果处理逻辑走到了这里，说明符合该阶梯的处理前提，开始正式进行优惠处理
    BigDecimal lastSubtotalAmount = lastCycleStepResult.getLastSubtotalAmount();
    BigDecimal lastSurplusSubtotalAmount = lastCycleStepResult.getLastSurplusSubtotalAmount();
    CycleStepResult newCycleStepResult = new CycleStepResult(index, times, lastSubtotalAmount, lastSurplusSubtotalAmount, lastSurplusSubtotalNumber);
    // 计算优惠后的金额： 原总计金额 - 小计折扣金额
    BigDecimal result = lastSubtotalAmount.subtract(discountValue);
    newCycleStepResult.setLastSubtotalAmount(result);
    // 本次计算结果作为下次计算的起始依据
    newCycleStepResult.setLastSurplusSubtotalAmount(result);
    newCycleStepResult.setLastSurplusSubtotalNumber(lastSurplusSubtotalNumber - fullCountValue);
    cycleExecuteContext.addStepResult(newCycleStepResult);
    return true;
  }
}
