package com.biz.crm.dms.business.policy.standard.fullminus.executestrategy;

import java.math.BigDecimal;
import java.util.Set;

import com.biz.crm.dms.business.policy.local.executestrategy.AbstractStandardExecuteStrategy;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.local.context.DefaultPolicyExecuteContext;
import com.biz.crm.dms.business.policy.local.context.UnitpriceCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.ProductPolicyStepResult;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.sdk.context.UnitpriceProduct;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.google.common.collect.Sets;

/**
 * 在商品满减优惠方式中使用的，满数量享单价满减的具体优惠执行策略
 * @author yinwenjie
 */
public abstract class AbstractFullminusUnitpriceExecuteStrategy extends AbstractStandardExecuteStrategy implements SalePolicyExecuteStrategy<SalePolicyExecutorVo> {
  
  /**
   * 该方法将有效减少各种 满减单价 优惠政策处理逻辑的代码冗余度
   * @param abstractExecuteContext
   * @param initPolicyProducts
   * @param customerCode
   * @return
   */
  protected UnitpriceCycleExecuteContext buildFullminusUnitpriceCycleExecuteContext(String executorCode , AbstractPolicyExecuteContext abstractExecuteContext, Set<SalePolicyConProduct> initPolicyProducts, String customerCode) {
    DefaultPolicyExecuteContext executeContext = (DefaultPolicyExecuteContext)abstractExecuteContext;
    /*
     * 由于 满减单价优惠政策需要在每一个阶梯执行过程中，记录参与本次优惠的所有本品的单价减少情况
     * 所以不能使用默认DefaultCycleExecuteContext阶梯执行上下文，而需要单独定义阶梯执行上下文
     * 
     * 构造步骤如下
     * 1、构造这个阶梯循环计算开始前的各种小计信息
     * 2、根据executeContext中每个本品的最新数量、单价情况，构造本品初始化信息
     * */
    
    // 1、======
    BigDecimal initSubtotalAmountForCycleExecutes = BigDecimal.ZERO;
    BigDecimal initSubtotalNumberForCycleExecutes = BigDecimal.ZERO;
    BigDecimal preSubtotalAmountForCycleExecutes = BigDecimal.ZERO;
    BigDecimal preSurplusSubtotalAmountForCycleExecutes = BigDecimal.ZERO;
    BigDecimal preSurplusSubtotalNumberForCycleExecutes = BigDecimal.ZERO;
    Set<SalePolicyConProduct> policyProductsForCycleExecutes = Sets.newLinkedHashSet();
    for (SalePolicyConProduct policyProductForCycleExecutes : initPolicyProducts) {
      policyProductsForCycleExecutes.add(policyProductForCycleExecutes);
      ProductPolicyStepResult productPolicyStepResult = executeContext.findLastProductStepResultByProductCode(policyProductForCycleExecutes.getProductCode());
      initSubtotalAmountForCycleExecutes = initSubtotalAmountForCycleExecutes.add(productPolicyStepResult.getInitSubtotal());
      initSubtotalNumberForCycleExecutes = initSubtotalNumberForCycleExecutes.add(new BigDecimal(productPolicyStepResult.getInitNumbers()));
      preSubtotalAmountForCycleExecutes = preSubtotalAmountForCycleExecutes.add(productPolicyStepResult.getLastSubtotal());
      preSurplusSubtotalAmountForCycleExecutes = preSurplusSubtotalAmountForCycleExecutes.add(productPolicyStepResult.getLastSurplusTotalAmount());
      preSurplusSubtotalNumberForCycleExecutes = preSurplusSubtotalNumberForCycleExecutes.add(new BigDecimal(productPolicyStepResult.getLastSurplusTotalNumber()));
    }
    
    // 2、=====
    Set<UnitpriceProduct> preFullminusUnitpriceProducts = Sets.newLinkedHashSet();
    for (SalePolicyConProduct policyConProduct : initPolicyProducts) {
      String productCode = policyConProduct.getProductCode();
      ProductPolicyStepResult productPolicyStepResult = executeContext.findLastProductStepResultByProductCode(productCode);
      Integer initNumbers = productPolicyStepResult.getInitNumbers();
      BigDecimal lastPrices = productPolicyStepResult.getLastPrices();
      
      // 加入到preFullminusUnitpriceProducts集合
      UnitpriceProduct fullminusUnitpriceProduct = new UnitpriceProduct(productCode, initNumbers, lastPrices);
      preFullminusUnitpriceProducts.add(fullminusUnitpriceProduct);
    }
    return new UnitpriceCycleExecuteContext(executorCode , customerCode , policyProductsForCycleExecutes, initSubtotalAmountForCycleExecutes, initSubtotalNumberForCycleExecutes.intValue(),
      preSubtotalAmountForCycleExecutes , preSurplusSubtotalAmountForCycleExecutes , preSurplusSubtotalNumberForCycleExecutes.intValue() , preFullminusUnitpriceProducts);
  }
}
