package com.biz.crm.dms.business.policy.standard.fullminus.executestrategy;

import org.apache.commons.lang3.StringUtils;

import com.biz.crm.dms.business.policy.local.cyclestrategy.AccumulationCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.MultipleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.SingleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;

/**
 * 在商品满减优惠方式中使用的，本品满数量享总价满减的具体优惠执行策略
 * @author yinwenjie
 */
public class ProductFullminusSubtotalCountExecuteStrategy extends AbstractFullminusSubtotalCountExecuteStrategy implements SalePolicyExecuteStrategy<SalePolicyExecutorVo> {
  
  @Override
  public String getExecuteStrategyCode() {
    return "productFullminusSubtotalCountExecuteStrategy";
  }

  @Override
  public String getExecuteStrategyDesc() {
    return "满数量享总价减";
  }

  @Override
  public String getExpression() {
    return "本单中本品数量购买满{integer:input-integer:fullCountValue}销售单位，本品总价减{decimal:input-random:priceValue}元";
  }
  
  @Override
  public String getCycleRuleExample(String cycleRuleCode) {
    // 写死即可
    if(StringUtils.equals(cycleRuleCode, SingleCycleRuleStrategy.SINGLE)) {
      return "例如：满1000销售单位总价减200，满500销售单位总价减100。那么本品销售数量为1300单位，销售金额为2000，则优惠结果为2000 - 200 = 1800";
    } else if(StringUtils.equals(cycleRuleCode, MultipleCycleRuleStrategy.MULTIPLE)) { 
      return "例如：满1000销售单位总价减200，满500销售单位总价减100。那么本品销售数量为1300单位，销售金额为2000，则优惠结果为2000 - 200 = 1800（因享受1000销售单位区间满减后，剩余未享受优惠的数量已不足500）";
    } else if(StringUtils.equals(cycleRuleCode, AccumulationCycleRuleStrategy.ACCUMULATION)) { 
      return "例如：满1000销售单位总价减200，满500销售单位总价减100。那么本品销售数量为2600单位，销售金额为2000，则优惠结果为2000 - 200 - 200 - 100 = 1500";
    }
    return "";
  }
}
