package com.biz.crm.dms.business.policy.standard.fullminus.executestrategy;

import com.biz.crm.dms.business.policy.local.cyclestrategy.AccumulationCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.MultipleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.SingleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;

import org.apache.commons.lang3.StringUtils;

/**
 * 在商品满减优惠方式中使用的，满金额（区间）享小计价格的具体优惠执行策略</p>
 * 
 * 2022-05-11 根据产品要求，在此日期前，该执行策略为满金额（区间）享单价满减；在此日期之后，该执行策略为满金额享单价满减；
 * 用于替换原来的ProductFullminusSubtotalPriceExecuteStrategy
 * 
 * @author yinwenjie
 */
public class ProductFullminusSubtotalPriceSectionExecuteStrategy extends AbstractFullminusSubtotalPriceSectionExecuteStrategy implements SalePolicyExecuteStrategy<SalePolicyExecutorVo> {
  
  @Override
  public String getExecuteStrategyCode() {
    return "productFullminusSubtotalPriceSectionExecuteStrategy";
  }

  @Override
  public String getExecuteStrategyDesc() {
    return "满金额总价满减";
  }

  @Override
  public String getExpression() {
    return "本单中本品金额购买满{integer:input-integer:fullPriceValue}元，优惠区间总价减{bigdecimal:input-random:priceValue}元";
  }
  
  public String getCycleRuleExample(String cycleRuleCode) {
    if(StringUtils.equals(cycleRuleCode, SingleCycleRuleStrategy.SINGLE)) {
      return "例如：满1000元总价减200，满800元总价减50。那么本品销售金额为1300，则优惠结果为1300 - 200 = 1100";
    } else if(StringUtils.equals(cycleRuleCode, MultipleCycleRuleStrategy.MULTIPLE)) { 
      return "例如：满1000元总价减200，满800元总价减50。那么本品销售金额为1300，则优惠结果为1300 - 200 = 1100 （因享受1000元区间满减后，剩余未享受优惠的金额已不足500）";
    } else if(StringUtils.equals(cycleRuleCode, AccumulationCycleRuleStrategy.ACCUMULATION)) { 
      return "例如：满1000元总价减200，满800元总价减50。那么本品销售金额为2900，则优惠结果为2900 - 200 - 200 - 50 = 2450";
    } 
    
    return "";
  }
}
