package com.biz.crm.dms.business.policy.standard.fullminus.executestrategy;

import com.biz.crm.dms.business.policy.local.cyclestrategy.AccumulationCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.MultipleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.SingleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;

import org.apache.commons.lang3.StringUtils;

/**
 * 在整单优惠方式中使用的，满数量享整单满减的具体优惠执行策略</br>
 * 注意：“整单满数量享整单满减”和“商品满数量享总价满减”FullminusSubtotalCountExecuteStrategy，除了描述信息不一样以外、从调用方接收的本品规模不一样，
 * 处理逻辑完全一样。所以可以直接集成AbstractFullminusSubtotalCountExecuteStrategy即可
 * @author yinwenjie
 */
public class WholeFullminusSubtotalCountExecuteStrategy extends AbstractFullminusSubtotalCountExecuteStrategy implements SalePolicyExecuteStrategy<SalePolicyExecutorVo> {

  @Override
  public String getExecuteStrategyCode() {
    return "wholeCountFullminusExecuteStrategy";
  }

  @Override
  public String getExecuteStrategyDesc() {
    return "整单满数量享总价减";
  }

  @Override
  public String getExpression() {
    return "本单数量购买满{integer:input-integer:fullCountValue}销售单位，整单减{decimal:input-random:priceValue}元";
  }
  
  @Override
  public String getCycleRuleExample(String cycleRuleCode) {
    if(StringUtils.equals(cycleRuleCode, SingleCycleRuleStrategy.SINGLE)) {
      return "例如：满1000销售单位总价减200，满500销售单位总价减100。那么整单销售数量为1300单位，销售金额为2000，则优惠结果为2000 - 200 = 1800";
    } else if(StringUtils.equals(cycleRuleCode, MultipleCycleRuleStrategy.MULTIPLE)) { 
      return "例如：满1000销售单位总价减200，满500销售单位总价减100。那么整单销售数量为1300单位，销售金额为2000，则优惠结果为2000 - 200 = 1800（因享受1000销售单位区间满减后，剩余未享受优惠的数量已不足500）";
    } else if(StringUtils.equals(cycleRuleCode, AccumulationCycleRuleStrategy.ACCUMULATION)) { 
      return "例如：满1000销售单位总价减200，满500销售单位总价减100。那么整单销售数量为2600单位，销售金额为2000，则优惠结果为2000 - 200 - 200 - 100 = 1500";
    }
    return "";
  }
}
