package com.biz.crm.dms.business.policy.standard.fullminus.executestrategy;

import com.biz.crm.dms.business.policy.local.cyclestrategy.AccumulationCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.MultipleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.SingleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;

import org.apache.commons.lang3.StringUtils;

/**
 * 在整单优惠方式中使用的，满金额（区间）享（区间）满减的具体优惠执行策略</br>
 * 注意：“满金额（区间）享（区间）满减”和“商品满金额（区间）享（区间）满减”FullminusSubtotalPriceSectionExecuteStrategy，除了描述信息不一样以外、从调用方接收的本品规模不一样，
 * 处理逻辑完全一样。所以可以直接集成AbstractFullminusSubtotalPriceSectionExecuteStrategy即可</p>
 * 
 * 2022-05-10 开始，该满金额（区间）享（区间）满减，变更为满金额享总价满减，用来替换之前的WholeFullminusSubtotalPriceExecuteStrategy的工作逻辑
 * 
 * @author yinwenjie
 */
public class WholeFullminusSubtotalPriceSectionExecuteStrategy extends AbstractFullminusSubtotalPriceSectionExecuteStrategy implements SalePolicyExecuteStrategy<SalePolicyExecutorVo> {
  
  @Override
  public String getExecuteStrategyCode() {
    return "wholePriceFullminusSectionExecuteStrategy";
  }

  @Override
  public String getExecuteStrategyDesc() {
    return "整单满金额享总价（区间）满减";
  }

  @Override
  public String getExpression() {
    return "整单本品金额购买满{decimal:input-integer:fullPriceValue}元，总价减{decimal:input-random:priceValue}元";
  }

  @Override
  public String getCycleRuleExample(String cycleRuleCode) {
    // 写死即可
    if(StringUtils.equals(cycleRuleCode, SingleCycleRuleStrategy.SINGLE)) { 
      return "例如：满1000元总价减200，满800元总价减50。那么整单销售金额为1300，则优惠结果为1300 - 200 = 1100";
    } else if(StringUtils.equals(cycleRuleCode, MultipleCycleRuleStrategy.MULTIPLE)) { 
      return "例如：满1000元总价减200，满800元总价减50。那么整单销售金额为1300，则优惠结果为1300 - 200 = 1100 （因享受1000元区间满减后，剩余未享受优惠的金额已不足500）";
    } else if(StringUtils.equals(cycleRuleCode, AccumulationCycleRuleStrategy.ACCUMULATION)) { 
      return "例如：满1000元总价减200，满800元总价减50。那么整单销售金额为2900，则优惠结果为2900 - 200 - 200 - 50 = 2450";
    } 
    return "";
  }
}
